document.addEventListener("DOMContentLoaded", function() {

  const popup = document.getElementById("customPopup");
  const agreeBtn = document.getElementById("agreeBtn");

  // Check if already agreed
  if (localStorage.getItem("agreedOnce") === "yes") {
      return;  // Do nothing (popup will never show)
  }

  // Show popup only for first time
  popup.style.display = "flex";

  agreeBtn.addEventListener("click", function() {

      // Mark accepted
      localStorage.setItem("agreedOnce", "yes");

      // Hide popup
      popup.style.display = "none";

      // Redirect
      window.location.href = "https://advancedemolink.com/nophan/"; 
  });
});