<?php
include('assets/inc/header.php');
?>
<section class="pages-sec" style="margin-bottom:150px; margin-top:50px;">
  <div class="container">
    <h1 class="head-text" data-aos="fade-up" data-aos-delay="200" style="font-size:55px; line-height: 55px;">DRIVER'S PRIVACY PROTECTION ACT</h1>
    <p>The <b>Driver's Privacy Protection Act of 1994</b> (also referred to as the "DPPA"), Title XXX of the <a href="https://en.wikipedia.org/wiki/Violent_Crime_Control_and_Law_Enforcement_Act">Violent Crime Control and Law Enforcement Act</a>, is a <a href="https://en.wikipedia.org/wiki/Law_of_the_United_States#Federal_law">United States federal statute</a> governing the privacy and disclosure of personal information gathered by state <a href="https://en.wikipedia.org/wiki/Department_of_motor_vehicles">Departments of Motor Vehicles</a>.</p>
<p>The law was passed in 1994. It was introduced by Democratic Rep. <a href="https://en.wikipedia.org/wiki/Jim_Moran">Jim Moran</a> of Virginia in 1992, after an increase in some opponents of abortion using public driving license databases to track down and harass abortion providers and patients. Prominent among such cases was physician <a href="https://en.wikipedia.org/wiki/Susan_Wicklund">Susan Wicklund</a>, who faced protests and harassment including her house being picketed for a month.[1] The law is currently <a href="https://en.wikipedia.org/wiki/Codification_(law)">codified</a> at Chapter 123 of <a href="https://en.wikipedia.org/wiki/Title_18_of_the_United_States_Code">Title 18 of the United States Code</a>.[2]</p>
<h2>Substantive provisions of the act</h2>
<p>The statute prohibits the disclosure of personal information (as defined in <a href="https://www.law.cornell.edu/uscode/text/18/2725">18 U.S.C. § 2725</a>) without the express consent of the person to whom such information applies, with the exception of certain circumstances set forth in <a href="https://www.law.cornell.edu/uscode/text/18/2721">18 U.S.C. § 2721</a>. These rules apply to Departments of Motor Vehicles as well as other "authorized recipient[s] of personal information", and imposes record-keeping requirements on those "authorized recipients."</p>
<p>The permissible uses are:[3]</p>
<ul>
    <li>For any government agency to carry out its functions</li>
    <li>2.	For use in connection with "matters of motor vehicle or driver safety and theft", including</li>
    <ul>
        <li>disclosure "in connection with matters of motor vehicle or driver safety and theft, motor vehicle emissions, motor vehicle product alterations, recalls, or advisories, performance monitoring of motor vehicles and dealers by motor vehicle manufacturers"</li>
        <li>removal of non-owner records from the original owner records of motor vehicle manufacturers to carry out the purposes of the Automobile Information Disclosure Act, the Motor Vehicle Information and Cost Saving Act, the <a href="https://en.wikipedia.org/wiki/National_Traffic_and_Motor_Vehicle_Safety_Act">National Traffic and Motor Vehicle Safety Act of 1966</a>, the Anti-Car Theft Act of 1992, and the <a href="https://en.wikipedia.org/wiki/Clean_Air_Act_(United_States)">Clean Air Act</a></li>
    </ul>
    <li>For use in the normal course of business by a legitimate business or its agents, employees, or contractors, but only to:</li>
    <ul>
        <li>verify the accuracy of personal information</li>
        <li>correct information</li>
    </ul>
    <li>For use in connection with any matter before a court or arbitration proceeding.</li>
    <li>For producing statistical reports and other research, provided that personal information is not published.</li>
    <li>6.	For use by insurance companies.</li>
    <li>7.	For providing notice to owners of towed vehicles.</li>
    <li>8.	For use by licensed private investigation agencies, for a permitted DPPA use.</li>
    <li>9.	For use by employers to verify commercial driver information as required by <a href="https://en.wikipedia.org/wiki/Title_49_of_the_United_States_Code">U.S. Code Title 49</a>, subtitle VI, chapter 313.</li>
    <li>10.	For use by private toll transportation facilities.</li>
    <li>11.	For response to requests from motor vehicle departments.</li>
    <li>12.	For the bulk distribution of surveys, marketing materials, or solicitations (<a href="https://en.wikipedia.org/wiki/Opt-in_email">opt-in</a> only).</li>
    <li>13.	When written consent of the individual is provided.</li>
    <li>14.	For other uses specifically authorized by state laws.</li>
</ul>
<p>The act also makes it illegal to obtain drivers' information for unlawful purposes or to make false representations to obtain such information.[4] The act establishes criminal fines for noncompliance,[5] and establishes a civil <a href="https://en.wikipedia.org/wiki/Cause_of_action">cause of action</a> for drivers against those who unlawfully obtain their information.[6]</p>
     </div>
</section>
<?php
include('assets/inc/footer.php');
?>