<?php
include('assets/inc/header.php');
?>
<section class="pages-sec" style="margin-bottom:150px; margin-top:50px;">
  <div class="container">
    <h1 class="head-text" data-aos="fade-up" data-aos-delay="200" style="font-size:55px; line-height: 55px;">THE GRAMM-LEACH-BIILEY ACT (GLBA)</h1>
    <p>The Gramm-Leach-Bliley Act (GLBA) is a U.S. law from 1999 that requires financial institutions to protect the privacy of consumers' non-public personal information (NPI) and to implement security measures to safeguard that data. It also repealed parts of the <a href="https://www.google.com/search?q=Glass-Steagall+Act&rlz=1C1_____enUS1183US1183&oq=GRAMMLEACH&gs_lcrp=EgZjaHJvbWUqDggBEAAYChgLGLEDGIAEMgYIABBFGDkyDggBEAAYChgLGLEDGIAEMgsIAhAAGAoYCxiABDILCAMQABgKGAsYgAQyCwgEEAAYChgLGIAEMgsIBRAAGAoYCxiABDILCAYQABgKGAsYgAQyCwgHEAAYChgLGIAE0gEINTQ0OGowajGoAgiwAgHxBd3b__lCyK5y&sourceid=chrome&ie=UTF-8&mstk=AUtExfAY4iJdN4PnIS-qphupVYnK6XBF3unkwaBHz-0mTBrH2t89Ytu3QFEenupJjubK37t15o08lXcLyTQkVAowPVhZUX9oHo7zmyosoapBGtV-V3meAs0hRABvogdchXiCxn4xlwuIJwOjcAp_eRmVyX90rzi94W1X3ea8hggYdaGElTB7e86ne6TKy-o47adQh4ei&csui=3&ved=2ahUKEwil7d3WhoSRAxWT1vACHb3gCe0QgK4QegYIAQgAEAM">Glass-Steagall Act</a> and <a href="https://www.google.com/search?q=Bank+Holding+Company+Act&rlz=1C1_____enUS1183US1183&oq=GRAMMLEACH&gs_lcrp=EgZjaHJvbWUqDggBEAAYChgLGLEDGIAEMgYIABBFGDkyDggBEAAYChgLGLEDGIAEMgsIAhAAGAoYCxiABDILCAMQABgKGAsYgAQyCwgEEAAYChgLGIAEMgsIBRAAGAoYCxiABDILCAYQABgKGAsYgAQyCwgHEAAYChgLGIAE0gEINTQ0OGowajGoAgiwAgHxBd3b__lCyK5y&sourceid=chrome&ie=UTF-8&mstk=AUtExfAY4iJdN4PnIS-qphupVYnK6XBF3unkwaBHz-0mTBrH2t89Ytu3QFEenupJjubK37t15o08lXcLyTQkVAowPVhZUX9oHo7zmyosoapBGtV-V3meAs0hRABvogdchXiCxn4xlwuIJwOjcAp_eRmVyX90rzi94W1X3ea8hggYdaGElTB7e86ne6TKy-o47adQh4ei&csui=3&ved=2ahUKEwil7d3WhoSRAxWT1vACHb3gCe0QgK4QegYIAQgAEAQ">Bank Holding Company Act</a>, allowing banks, securities firms, and insurance companies to merge. Key requirements include providing customers with a privacy notice, giving them the right to opt out of having their information shared with non-affiliated third parties, and developing a comprehensive information security program. </p>
        <h2>Key provisions of the GLBA</h2>
        <ul>
            <li><b>Financial Privacy Rule</b>: Mandates that financial institutions provide customers with a privacy notice explaining what information they collect, how it's used, and with whom it's shared.</li>
            <li><b>Opt-out Right</b>: Gives consumers the right to prevent their financial information from being shared with third parties, with some exceptions.</li>
            <li><a href="https://www.google.com/search?q=Safeguards+Rule&rlz=1C1_____enUS1183US1183&oq=GRAMMLEACH&gs_lcrp=EgZjaHJvbWUqDggBEAAYChgLGLEDGIAEMgYIABBFGDkyDggBEAAYChgLGLEDGIAEMgsIAhAAGAoYCxiABDILCAMQABgKGAsYgAQyCwgEEAAYChgLGIAEMgsIBRAAGAoYCxiABDILCAYQABgKGAsYgAQyCwgHEAAYChgLGIAE0gEINTQ0OGowajGoAgiwAgHxBd3b__lCyK5y&sourceid=chrome&ie=UTF-8&mstk=AUtExfAY4iJdN4PnIS-qphupVYnK6XBF3unkwaBHz-0mTBrH2t89Ytu3QFEenupJjubK37t15o08lXcLyTQkVAowPVhZUX9oHo7zmyosoapBGtV-V3meAs0hRABvogdchXiCxn4xlwuIJwOjcAp_eRmVyX90rzi94W1X3ea8hggYdaGElTB7e86ne6TKy-o47adQh4ei&csui=3&ved=2ahUKEwil7d3WhoSRAxWT1vACHb3gCe0QgK4QegYIAQgAEAw">Safeguards Rule</a>: Requires financial institutions to develop, implement, and maintain a comprehensive security program with administrative, technical, and physical safeguards to protect customer data.</li>
            <li><b>Pretexting Prevention</b>: Addresses the collection of customer information under false pretenses through measures like employee training. </li>
        </ul>
        <h2>Repeal of previous laws </h2>
        <ul>
            <li>The GLBA repealed parts of the Glass-Steagall Act of 1933, which had separated commercial and investment banking.</li>
            <li>It also repealed sections of the Bank Holding Company Act of 1956, allowing for the integration of banking, securities, and insurance activities. </li>
        </ul>
        <h2>Who it applies to</h2>
        <ul>
            <li>The GLBA applies to a wide range of organizations "significantly engaged" in financial services, including banks, lenders, mortgage brokers, insurance companies, and tax preparers. </li>
        </ul>
        <h2>Amendments and updates</h2>
        <ul>
        <li>New amendments to the Safeguards Rule went into effect in 2023, introducing more detailed requirements for information security programs and adding a mandatory notification requirement for certain security events where 500 or more individuals are affected. </li>
        </ul>
     </div>
</section>
<?php
include('assets/inc/footer.php');
?>