<?php
include 'inc/header.php';

// Check if user is logged in
if (!isset($_SESSION['USER_ID'])) {
   echo "<script>window.location.href = '../login.php';</script>";
exit;
}

// Store user info
$user_id = $_SESSION['USER_ID'];
$user_role = $_SESSION['USER_ROLE'] ?? '';

// Verify admin access
if ($user_role !== 'admin') {
    echo "<script>window.location.href = '../login.php';</script>";
    exit;
}

$showcat  = "SELECT * FROM `tbl_register` where role not like 'admin' ORDER BY id DESC";

$result = mysqli_query($conn, $showcat);

$data = array();

if (mysqli_num_rows($result) > 0) {

  while ($row = mysqli_fetch_assoc($result)) {

    $data[] = $row;
  }
}



?>


<!-- DataTales Example -->
<div class="card shadow mb-4">
  <div class="card-header py-3">
    <h6 class="m-0 font-weight-bold text-secondary">Show Membership Users</h6>
  </div>
  <div class="card-body">
    <div class="table-responsive">

      <table id="couponTable" class="table table-bordered" width="100%" cellspacing="0">

        <thead>

          <tr>

            <th scope="col">Id</th>

            <th scope="col">First Name</th>

            <th scope="col">Last Name</th>

            <th scope="col">Email</th>

            <th scope="col">Phone</th>

            <th scope="col">Membership Type</th>

            <th scope="col">Status</th>

            <th scope="col">Created Date</th>

          





          </tr>

        </thead>

        <tbody>

          <?php foreach ($data as $row) : ?>

            <tr>

              <td><?php echo $row['id'] ?></td>

              <td><?php echo $row['first_name'] ?></td>

              <td><?php echo $row['last_name'] ?></td>

              <td><?php echo $row['email'] ?></td>

              <td><?php echo $row['phone'] ?></td>

              <td><?php echo $row['membership_type'] ?></td>



              <td>



                <?php

                if ($row['status'] == 'active') { ?>

                  <span class="badge bg-success text-white">Active</span>

                <?php

                } else { ?>

                  <span class="badge bg-danger text-white">In-Active</span>

                <?php



                }

                ?>

              </td>



              <td>
                <?php echo $row['created_date'] ?>

              </td>
            </tr>

          <?php endforeach; ?>

        </tbody>

      </table>


    </div>
  </div>
</div>



<?php

include 'inc/footer.php';

?>





<script>
  $(document).ready(function() {

    $('#couponTable').DataTable();



    //Delete cat

    $(document).on("click", ".delete-btn", function(e) {

      // console.log("working");

      e.preventDefault();

      var confirmation = confirm("Are you sure you want to delete this Coupon?");

      if (confirmation) {

        var user_id = $(this).data("id");

        // console.log(user_id);

        var element = this;



        $.ajax({

          url: "delete_coupon.php",

          type: "POST",

          data: {

            id: user_id

          },

          success: function(data) {

            if (data == 1) {



              $(element).closest("tr").fadeOut().css("background-color", "#FF7F7F");

            } else {

              toastr.error('Can not Deleted', 'Error');

              $(".error").html("Can't Delete Record").slideDown();

            }

          }

        });

      }

    });



  });
</script>