// Register Form
// Reset border color on focus/change
$("#fname, #lname, #email, #membership_type, #password, #phone").on("focus change", function () {
  $(this).css("border", "1px solid #ced4da");
});

$("#signupform").submit(function (e) {
  e.preventDefault();
  
  var fname = $("#fname").val();
  var lname = $("#lname").val();
  var email = $("#email").val();
  var phone = $("#phone").val();
  var password = $("#password").val();
  var membership_type = $("#membership_type").val();

  var is_error = false;

  // Validation
  if (fname.trim() === "") { $("#fname").css("border", "1px solid red"); is_error = true; }
  if (lname.trim() === "") { $("#lname").css("border", "1px solid red"); is_error = true; }
  if (email.trim() === "") { $("#email").css("border", "1px solid red"); is_error = true; }
  if (phone.trim() === "") { $("#phone").css("border", "1px solid red"); is_error = true; }
  if (password.trim() === "") { $("#password").css("border", "1px solid red"); is_error = true; }
  if (!membership_type || membership_type === "") {
    $("#membership_type").css("border", "1px solid red");
    is_error = true;
  }

  if (!is_error) {
    var formData = $(this).serialize();
    $.ajax({
      url: "register_query.php",
      type: "POST",
      data: formData,
      success: function (response) {
        if (response == 1) {
          $("#signupform").trigger("reset");
          toastr.success("Registration has been submitted successfully!", "Success");
        } else if (response == 2) {
          toastr.error("Registration already exists", "Error");
        } else if (response == 3) {
          toastr.error("Password Does not Match", "Error");
        } else {
          toastr.error("Failed to register. Please try again later.", "Error");
        }
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        toastr.error("An error occurred while processing your request.", "Error");
      },
    });
  }
});


//LOGIN fORM
$("#loginform").submit(function (e) {
  e.preventDefault();
  var lemail = $("#lemail").val();
  var lpassword = $("#lpassword").val();
  var is_error = true;

  if (lemail == "") {
    $("#lemail").css("border", "1px solid red");
    is_error = false;
  }
  if (lpassword == "") {
    $("#lpassword").css("border", "1px solid red");
    is_error = false;
  }

  $("#lemail").focus(function () {
    $("#lemail").css("border", "1px solid #ced4da");
  });
  $("#lpassword").focus(function () {
    $("#lpassword").css("border", "1px solid #ced4da");
  });

  if (is_error) {
    var formData = $(this).serialize();
    $.ajax({
      url: "login_query.php",
      type: "POST",
      data: formData,
      success: function (response) {
        console.log("Server response:", response);

        if (response == "admin") {
          toastr.success("Login successful!", "Success");
          setTimeout(function () {
            window.location.href = "admin/show_memberships.php"; // Or change based on role
          }, 2000);
        }
         else if (response == "user") {
            toastr.success("Login successful!", "Success");
             setTimeout(function () {
            window.location.href = "index.php"; // Or change based on role
          }, 2000);
        }
        else if (response == "inactive") {
          toastr.warning("Your account is inactive. Please contact support.", "Inactive");
        } else if (response == "invalid") {
          toastr.error("Invalid username or password!", "Error");
        } else {
          toastr.error("Unexpected response: " + response);
        }
      },
      error: function (xhr, status, error) {
        console.log(xhr.responseText);
      },
    });
  }
});
