<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Earth Riders</title>
  <link rel="icon" type="image/png" href="assets/images/favicon.png">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700&family=Barlow:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

  <!-- External CSS Libraries -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
  <link rel="stylesheet" href="https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css" />

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>


  <section class="hero">
    <div class="navbar" data-aos="fade-down" data-aos-duration="1000">
      <a href="index.php">
        <img src="assets/images/logo.png" alt="" class="logo">
      </a>

        <div class="nav-item">
  <a href="index.php">Home</a>

  <!-- Dropdown -->
  <div class="dropdown">
    <a href="board-members.php" class="dropbtn">board members <span class="arrow">&#9662;</span></a>
    <div class="dropdown-content">
      <a href="assets/pdf/nitrogen-management.pdf" target="_blank">Nitrogen Management</a>
<a href="assets/pdf/phosphorus-management.pdf" target="_blank">Phosphorus Management</a>
<a href="assets/pdf/cafo.pdf" target="_blank">CAFO</a>

    </div>
  </div>
<div class="dropdown">
    <a href="services.php" class="dropbtn">Services <span class="arrow">&#9662;</span></a>
    <div class="dropdown-content" style="min-width:214px; left: -56px;
">
      <a href="education.php" >Education</a>
<a href="seminars.php">Onsite Seminars</a>
<a href="membership.php" >Membership</a>
<a href="scholarships.php" >Scholarships</a>
<a href="policy.php">Policy Advocacy</a>
<a href="composting.php" >Composting Network</a>

    </div>
  </div>
  <a href="partners.php">Partners</a>
  <a href="testimonial.php">Testimonials</a>
  <a href="contact.php">Contact</a>
    <a href="register.php">SignUp</a>
</div>
    </div>
    <div class="hero-sec">
      <img src="assets/images/image-hero.png" alt="" class="hero-img"
        data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">

      <div class="hero-text">
        <h4 data-aos="fade-up" data-aos-duration="800" data-aos-delay="200">Welcome To</h4>
        <h1 data-aos="fade-up" data-aos-duration="800" data-aos-delay="400">Earth Riders</h1>
        <p data-aos="fade-up" data-aos-duration="800" data-aos-delay="600">
        We believe every ride can make a difference. By merging passion with purpose,  we’re creating a movement of riders who care for the Earth. Together, we ride toward a cleaner, more sustainable future.
        </p>

        <div class="btn" data-aos="zoom-in" data-aos-delay="800" data-aos-duration="1000">
          <h3 onclick="window.location.href='about-us.php'">Get Started</h3>
        </div>

<!--        <h6 -->
<!--  data-aos="fade-up" -->
<!--  data-aos-delay="1000" -->
<!--  data-aos-duration="800" -->
<!--  id="scroll-down"-->
<!--  style="cursor: pointer; color: #40ADE3; text-decoration: underline;"-->
<!-->-->
<!--  scroll down-->
<!--</h6>-->
<div data-aos="fade-up" 
  data-aos-delay="1000" 
  data-aos-duration="800" 
  id="scroll-down"
  style="cursor: pointer;"> <img src="assets/images/scroll.svg" 
     alt="Scroll Indicator" 
     class="scroll-indicator"
     style="width: 195px; height: 66px; margin-top: 64px;">
</div>

        <div class="icons" data-aos="fade-up" data-aos-delay="1200" data-aos-duration="800">
          <i class="fa-brands fa-facebook-f"></i>
          <i class="fa-brands fa-twitter"></i>
          <i class="fa-brands fa-youtube"></i>
          <i class="fa-brands fa-instagram"></i>
          <i class="fa-brands fa-linkedin-in"></i>
        </div>
      </div>
    </div>
  </section>


  <section class="about" id="scroll-sec">
  <div class="container-fluid">
    <div class="row align-items-center px-5">
      <!-- Image Column -->
      <div class="col-lg-6 col-md-12 text-center text-lg-start" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
        <img src="assets/images/sec-1.png" alt="About Image" class="img-fluid about-img">
      </div>

      <!-- Text Column -->
      <div class="col-lg-6 col-md-12 about-text" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
        <h1 data-aos="fade-up" data-aos-delay="400">What is The Earth-Riders Club?</h1>
        <p data-aos="fade-up" data-aos-delay="600">
          As a non-profit organization 501c4, we provide equestrians with a green plan.
          For the future of equine sport we change equestrian identity from polluter to protector
          of natural resources. "Immaculate Collection, Equestrian Topsoil, and winning the Earthshot Prize
          are the three pillars."
        </p>

        <div class="btn mt-3" data-aos="zoom-in" data-aos-delay="500">
          <h3 class="learn-more" onclick="window.location.href='board-members.php'">Learn More</h3>
        </div>
      </div>
    </div>
  </div>
</section>


  <section class="tools">
    <h1 data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">Tools, News, Memberships, Scholarships, Haul off <br> and Compost Network, Policy Advocacy  to  <br> ensure horses are welcome in the <br> modern  and changing world.</h1>
    <p data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400">
        Newsletters, Memberships, Scholarships, Compost Network, Policy Advocacy to ensure horses are welcome in the modern and changing world.
    </p>
    <div class="card-box scroll-container" data-aos="fade-up">
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600">
    <img src="assets/images/s-1.png" alt="">
    <a href="education.php"><img src="assets/images/arrow.png" alt="" class="arrow"> </a>
    <h3>Education via Newsletter</h3>
    <p>8 years ago we were targeted as equestrians for our carelessness with local water runoff.    </p>
  </div>
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="800">
    <img src="assets/images/s-5.png" alt="">
    <a href="seminars.php"><img src="assets/images/arrow.png" alt="" class="arrow"> </a>
    <h3>Onsite Seminars</h3>
    <p> Seminars scheduled for 45 minutes have regularly gone on for a few hours, with parents  ...</p>
  </div>
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="1000">
    <img src="assets/images/ser-04.png" alt="">
    <a href="membership.php"><img src="assets/images/arrow.png" alt="" class="arrow"> </a>
    <h3>Membership</h3>
    <p>Equestrians are unrepresented at key public policy meetings.  We know, because we go...  </p>
  </div>
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600">
    <img src="assets/images/ser-03.png" alt="">
    <a href="scholarship.php"><img src="assets/images/arrow.png" alt="" class="arrow"> </a>
    <h3>Scholarship Applicants</h3>
    <p>The step from passive spectator to active supporter can be instant.  Once you ... </p>
  </div>
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600">
    <img src="assets/images/ser-05.png" alt="">
    <a href="advocacy.php"><img src="assets/images/arrow.png" alt="" class="arrow"> </a>
    <h3>Policy Advocacy</h3>
    <p>Alissa Keny Guyer from the “wall of mom’s”, Erin Brockovich at the LA Fire Soil Testing Townhall.</p>
  </div>
  <div class="cards" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="800">
    <img src="assets/images/ser-06.png" alt="">
    <img src="assets/images/arrow.png" alt="" class="arrow">
    <h3>Composting Network</h3>
    <p>The Composting Network : Every barn should either be composting onsite.</p>
  </div>
</div>

  </section>
    <section class="process-row">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="process-sec">
                        <h3>Equestrian Environmental Plans are based on three principles</h3>
                        <ul>
                            <li>Immaculate Collection</li>
                            <li>Keep Manure Dry,</li>
                            <li>Compost to Produce the Soil Natural Resource.</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="process-sec">
                        <h3>The Equestrian Compliance Alliance is based on the 10 New Equestrian Center BMP’s</h3>
                        <p>Post list here.</p>
                        <ul>
                            <li>New Rules were inspired by the Ponies of Chincoteague.</li>
                            <li>New Rules were inspired by Apricot Lane Farm- "the biggest little Farm."</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
  <section class="about">
  <div class="container-fluid">
    <div class="row align-items-center px-5">
      <!-- Image Column -->
      <div class="col-lg-6 col-md-12 text-center text-lg-start" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
        <img src="assets/images/farm-1.png" alt="About Image" class="img-fluid about-img">
      </div>

      <!-- Text Column -->
      <div class="col-lg-6 col-md-12 about-text" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
        
        <h1 data-aos="fade-up" data-aos-delay="400">21st Century “Three r’s”- Retain, Recharge, Regenerate.  </h1>
        <p data-aos="fade-up" data-aos-delay="500">Cows, Sheep, Horses and Pigs graze in between Avocado and Fruit orchards.  Every part of the farm is under 12 inches of compost enriched soil.</p>
        <p data-aos="fade-up" data-aos-delay="600">The Results?  20 Degrees Cooler.  50% less water demand.  No Chemical Fertilizers, Pesticides, or even vaccines.  Fire runs past.</p>
        


        <div class="btn mt-3" data-aos="zoom-in" data-aos-delay="500">
          <h3 class="learn-more" onclick="window.location.href='farm.php'">Donate Now</h3>
        </div>
      </div>
    </div>
  </div>
</section>
   <section class="about" style="margin-top:150px">
  <div class="container-fluid">
    <div class="row align-items-center px-5">
      

      <!-- Text Column -->
      <div class="col-lg-6 col-md-12 about-text" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
        <h1 data-aos="fade-up" data-aos-delay="400">We took a cue from Chincoteague-  
Galway Downs is an Ecosystem!
</h1>
        <p data-aos="fade-up" data-aos-delay="500">The famous children’s book is based on the real life ecosystem off Virginia.  400 years ago, a shipwreck dropped a small herd of Spanish descent.  Somehow, they not only survived, but thrived.</p>
        <p data-aos="fade-up" data-aos-delay="600">Here we follow their example.  Not just with clean arenas and stalls, but grass, and flowers, trees and shrubs that grow, beautifully, fed by nutrients your horses produce, that we carefully compost.  Galway is becoming “Regenerative” to make use of nutrients and prevent runoff, to draw down carbon from the atmosphere, and to create water storage, prevent fire, as only living soil can…</p>

        <div class="btn mt-3" data-aos="zoom-in" data-aos-delay="500">
          <h3 class="learn-more" onclick="window.location.href='galway.php'">Learn More</h3>
        </div>
      </div>
      <!-- Image Column -->
      <div class="col-lg-6 col-md-12 text-center text-lg-start" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
        <img src="assets/images/sec5.png" alt="About Image" class="img-fluid about-img">
      </div>
    </div>
  </div>
</section>
  <!-- <section class="sec-4">
    <h1 data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">Voices of Change from Our <br> Equestrian Community</h1>
    <p data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>
    <div class="testimonials">
      <div class="testimonial" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600">
        <i class="fa-solid fa-quote-right"></i>
        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s</p>
        <div class="user">
          <img src="assets/images/user-1.png" alt="" class="user-img">
          <div class="user-text">
            <h3>Ashley Callahan</h3>
            <h4>Austin, TX</h4>
          </div>
        </div>
      </div>
      <div class="testimonial" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="800">
        <i class="fa-solid fa-quote-right"></i>
        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s</p>
        <div class="user">
          <img src="assets/images/user-2.png" alt="" class="user-img">
          <div class="user-text">
            <h3>Adrian “Andy” Davis</h3>
            <h4>Boston, MA</h4>
          </div>
        </div>
      </div>
      <div class="testimonial" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="1000">
        <i class="fa-solid fa-quote-right"></i>
        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s</p>
        <div class="user">
          <img src="assets/images/user-1.png" alt="" class="user-img">
          <div class="user-text">
            <h3>Mike Amy Barnhart</h3>
            <h4>Austin, TX</h4>
          </div>
        </div>
      </div>
    </div>
  </section> -->
<section id="faq" class="py-5">
  <div class="container">
    <!-- Section Title -->
    <div class="text-center mb-5 text-white">
      <h2 class="">Frequently Asked Questions</h2>
      <p class="lead">Here are some of the most common questions and answers.</p>
    </div>

    <!-- FAQ Accordion -->
    <div class="accordion" id="faqAccordion">
      
      <!-- FAQ Item 1 -->
      <div class="accordion-item mb-3" style="border-radius: 10px; overflow: hidden;">
        <h2 class="accordion-header" id="headingOne">
          <button class="accordion-button bg-white text-dark fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
           I'm only one rider, how can I make a difference?
          </button>
        </h2>
        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
          <div class="accordion-body bg-white text-dark">
            It's as easy as scooping poop! "Only rain down the drain" is the first step towards a healthy environment. The 2nd step is educating your peers and encouraging them to clean up the washracks
          </div>
        </div>
      </div>

      <!-- FAQ Item 2 -->
      <div class="accordion-item mb-3" style="border-radius: 10px; overflow: hidden;">
        <h2 class="accordion-header" id="headingTwo">
          <button class="accordion-button collapsed bg-white text-dark fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
           How does scooping manure help the environment?
          </button>
        </h2>
        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
          <div class="accordion-body bg-white text-dark">
           When un-composted horse manure is washed down the drain, it introduces a "nutrient bomb" to your local watershed. This causes algae blooms, which then strip the water of it's oxygen, not leaving enough for other types of plants and animals to thrive, and potentially releasing toxins into our water supply.
          </div>
        </div>
      </div>

      <!-- FAQ Item 3 -->
      <div class="accordion-item mb-3" style="border-radius: 10px; overflow: hidden;">
        <h2 class="accordion-header" id="headingThree">
          <button class="accordion-button collapsed bg-white text-dark fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
            How does composting manure make it fertilizer?
          </button>
        </h2>
        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
          <div class="accordion-body bg-white text-dark">
            The composting process kills pathogens and parasites that are found in raw manure. When manure compost is used to create soil, it introduced import nutrients in a safe way to help promote the growth of plant life.
        </div>
      </div>

    </div>
    <!-- FAQ Item 4 -->
      <div class="accordion-item mb-3" style="border-radius: 10px; overflow: hidden;">
        <h2 class="accordion-header" id="headingFour">
          <button class="accordion-button collapsed bg-white text-dark fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
            What is going on with Equestrian Centers?
          </button>
        </h2>
        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#faqAccordion">
          <div class="accordion-body bg-white text-dark">
           California Equestrian Centers are obligated to comply with agricultural laws for housed livestock keeping that were really written for keeping cattle. They require a "poop lagoon" to store manure in, since cow manure has a very high water content. Horse manure has a much lower water content, and since they are individually stalled in cozy beds of shavings, a lagoon would be no help to us. Unfortunately equestrian centers of a certain size are still required to follow these laws or face heavy fines. We can help navigate the laws, and advocate for change! 
        </div>
      </div>

    </div>
  </div>
</section>

 <section class="about" style="margin-bottom:200px ;">
  <div class="container-fluid">
    <div class="row align-items-center px-5">
      <!-- Image Column -->
      <div class="col-lg-6 col-md-12 text-center text-lg-start" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
        <img src="assets/images/elephant.png" alt="About Image" class="img-fluid about-img">
      </div>

      <!-- Text Column -->
      <div class="col-lg-6 col-md-12 about-text" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
        <h1 data-aos="fade-up" data-aos-delay="400">They said “Your Horses are Polluters…” But when I took a closer look...</h1>
        <p data-aos="fade-up" data-aos-delay="600">
         Our Horses are producers.  And if we compost for 90 days, our horses are quietly restoring LA Municipal Parks, and growing Avocados, Lemons, Mushrooms, Peppers, and fighting drought and wildfire.  So all we have to do is pick up after our horses, and then we grow great foods and restore soil and fight dourtgh, fire and Climate Change?  
        </p>

        <div class="btn mt-3" data-aos="zoom-in" data-aos-delay="500">
          <h3 class="learn-more" onclick="window.location.href='producers.php'">Learn More</h3>
        </div>
      </div>
    </div>
  </div>
</section>

  <!-- <section class="vids">
    <div class="vids-text">
      <h1 data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">see our <br> video <br>
        presentation</h1>
      <p data-aos="fade-up" data-aos-delay="400">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy.</p>
    </div>
    <div class="video-wrapper" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="600">
      <video src="assets/videos/sample.mp4" poster="assets/images/thumbnail.png"></video>
    </div>



  </section> -->

  <section class="news" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
    <img src="assets/images/stars.png" alt="" class="stars" data-aos="fade-down" data-aos-duration="1000" data-aos-delay="100">
    <h1 data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">subscribe to receive exclusive <br> news and offer</h1>
    <p data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500">Lorem ipsum dolor sit amet, consectetur adipiscing dolor sit amet</p>
    <div class="box-input" data-aos="zoom-in" data-aos-duration="1000" data-aos-delay="700">
      <input type="text" placeholder="Your Email Address">
      <div class="input-arrow">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14" fill="none">
          <path d="M0.951172 5.90469C0.454116 5.90469 0.0511719 6.30763 0.0511719 6.80469C0.0511719 7.30174 0.454116 7.70469 0.951172 7.70469V6.80469V5.90469ZM19.1889 7.44108C19.5404 7.08961 19.5404 6.51976 19.1889 6.16829L13.4613 0.440727C13.1098 0.0892548 12.54 0.0892548 12.1885 0.440727C11.8371 0.792198 11.8371 1.36205 12.1885 1.71352L17.2797 6.80469L12.1885 11.8959C11.8371 12.2473 11.8371 12.8172 12.1885 13.1686C12.54 13.5201 13.1098 13.5201 13.4613 13.1686L19.1889 7.44108ZM0.951172 6.80469V7.70469H18.5525V6.80469V5.90469H0.951172V6.80469Z" fill="white" />
        </svg>
      </div>
    </div>
  </section>
  <footer>
    <div class="footer-con" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
       <a href="index.php">
   <img src="assets/images/logo.png" alt="" class="logo">
      </a>
      <div class="footer-item">
        <a href="index.php" data-aos="fade-up" data-aos-delay="300">Home</a>
        <a href="board-members.php" data-aos="fade-up" data-aos-delay="400">Board Members</a>
        <a href="services.php" data-aos="fade-up" data-aos-delay="500">Services</a>
        <a href="testimonial.php" data-aos="fade-up" data-aos-delay="600">Testimonials</a>
        <a href="contact.php" data-aos="fade-up" data-aos-delay="700">Contact</a>
      </div>
    </div>
    <div class="line"></div>
    <div class="footer-social" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="800">
      <div class="social">
        <i class="fa-solid fa-phone-volume"></i>
        <p>818-943-7102</p>
      </div>
      <div class="social">
        <i class="fa-solid fa-envelope"></i>
        <p>info@earthrider.com</p>
      </div>
       <div class="social">
        <i class="fa-solid fa-location-dot"></i>
     <p style="text-transform: uppercase;">
  Sebastopol, Pleasanton, Lakeview Terrace, Anaheim Hills, Temecula
</p>
</div>

      <div class="footer-icons">
        <i class="fa-brands fa-facebook-f" data-aos="fade-up" data-aos-delay="900"></i>
        <i class="fa-brands fa-twitter" data-aos="fade-up" data-aos-delay="1000"></i>
        <i class="fa-brands fa-youtube" data-aos="fade-up" data-aos-delay="1100"></i>
        <i class="fa-brands fa-instagram" data-aos="fade-up" data-aos-delay="1200"></i>
        <i class="fa-brands fa-linkedin-in" data-aos="fade-up" data-aos-delay="1300"></i>
      </div>
    </div>
  </footer>
  <div class="footer-bottom" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="1400">
    <h3>POWERED BY <a href="https://webdesignsigma.com/" target="blank"> WEBdesign sigma</a></h3>
    <h4>earthrider</h4>
  </div>

  <!-- JS Libraries -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.rawgit.com/michalsnik/aos/1.0.1/dist/aos.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>

  <script src="assets/js/custom.js"></script>
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script>
    AOS.init({
      once: true, // animate only once
      duration: 1000, // default animation duration
      offset: 100 // trigger offset
    });


    document.querySelectorAll('.scroll-container').forEach(scrollContainer => {
  let isDown = false;
  let startX = 0;
  let scrollLeft = 0;
  let isDragging = false;

  scrollContainer.addEventListener('mousedown', (e) => {
    e.preventDefault();
    isDown = true;
    isDragging = false;
    scrollContainer.style.cursor = 'grabbing';
    startX = e.pageX - scrollContainer.offsetLeft;
    scrollLeft = scrollContainer.scrollLeft;
  });

  scrollContainer.addEventListener('mouseleave', () => {
    isDown = false;
    scrollContainer.style.cursor = 'grab';
  });

  scrollContainer.addEventListener('mouseup', () => {
    isDown = false;
    setTimeout(() => (isDragging = false), 50);
    scrollContainer.style.cursor = 'grab';
  });

  scrollContainer.addEventListener('mousemove', (e) => {
    if (!isDown) return;
    isDragging = true;
    const x = e.pageX - scrollContainer.offsetLeft;
    const walk = (x - startX) * 1.8;
    scrollContainer.scrollLeft = scrollLeft - walk;
  });

  // Touch events
  let touchStartX = 0;
  let touchScrollLeft = 0;

  scrollContainer.addEventListener('touchstart', (e) => {
    touchStartX = e.touches[0].pageX - scrollContainer.offsetLeft;
    touchScrollLeft = scrollContainer.scrollLeft;
  });

  scrollContainer.addEventListener('touchmove', (e) => {
    const x = e.touches[0].pageX - scrollContainer.offsetLeft;
    const walk = (x - touchStartX) * 1.3;
    scrollContainer.scrollLeft = touchScrollLeft - walk;
  });

  // Prevent image drag interference
  scrollContainer.querySelectorAll('img').forEach(img => {
    img.addEventListener('dragstart', e => e.preventDefault());
    img.addEventListener('click', e => {
      if (isDragging) e.preventDefault();
    });
  });
});


document.getElementById('scroll-down').addEventListener('click', function() {
    const target = document.getElementById('scroll-sec');
    target.scrollIntoView({
      behavior: 'smooth',
      block: 'start'
    });
  });
  </script>
</body>

</html>