<?php
require_once("inc/header.php");

$cats = $conn->query("SELECT * FROM `categories` ORDER BY `name` ASC");
?>
<div class="page-content container container-plus">
    <div class="card acard mt-2 mt-lg-3">
        <div class="card-header">
            <h3 class="card-title text-125 text-primary-d2">
                <i class="far fa-edit text-dark-l3 mr-1"></i>
                Add Product Time
            </h3>
        </div>

        <div class="card-body px-3 pb-1">
            <form id="addProducttimeForm" method="post" class="mt-lg-3" autocomplete="off">

                <!-- CATEGORY -->
                <div class="form-group row">
                    <div class="col-sm-3 col-form-label text-sm-right pr-0">
                        <label class="mb-0">Category</label>
                    </div>
                    <div class="col-sm-9">
                        <select name="category" id="category" class="form-control col-sm-8 col-md-6">
                            <option value="">-- Select Category --</option>
                            <?php while ($c = $cats->fetch_assoc()): ?>
                            <option value="<?= $c['cat_id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
                            <?php endwhile; ?>
                        </select>
                        <span id="cat_err" class="text-danger small"></span>
                    </div>
                </div>

                <!-- PRODUCT -->
                <div class="form-group row">
                    <div class="col-sm-3 col-form-label text-sm-right pr-0">
                        <label class="mb-0">Product</label>
                    </div>
                    <div class="col-sm-9">
                        <select name="product" id="product" class="form-control col-sm-8 col-md-6">
                            <option value="">-- Select Product --</option>
                        </select>
                        <span id="prod_err" class="text-danger small"></span>
                    </div>
                </div>

                <!-- TIME SLOTS -->
                <div class="form-group row">
                    <div class="col-sm-3 col-form-label text-sm-right pr-0">
                        <label class="mb-0">Available Time Slots</label>
                    </div>
                    <div class="col-sm-9">
                        <div id="timeSlots">
                            <label><input type="checkbox" name="time_slots[]" value="9:00 AM"> 9:00 AM</label><br>
                            <label><input type="checkbox" name="time_slots[]" value="10:00 AM"> 10:00 AM</label><br>
                             <label><input type="checkbox" name="time_slots[]" value="11:00 AM"> 11:00 AM</label><br>
                            <label><input type="checkbox" name="time_slots[]" value="12:00 PM"> 12:00 PM</label><br>
                             <label><input type="checkbox" name="time_slots[]" value="01:00 AM"> 01:00 AM</label><br>
                            <label><input type="checkbox" name="time_slots[]" value="2:00 PM"> 2:00 PM</label><br>
                            <label><input type="checkbox" name="time_slots[]" value="3:00 PM"> 3:00 PM</label><br>
                            <label><input type="checkbox" name="time_slots[]" value="4:00 PM"> 4:00 PM</label><br>
                        </div>
                    </div>
                </div>

                <div class="mt-5 border-t-1 bgc-secondary-l4 brc-secondary-l2 py-35 mx-n25">
                    <div class="offset-md-3 col-md-9 text-nowrap">
                        <button class="btn btn-primary btn-bold px-4" type="submit">
                            <i class="fa fa-check mr-1"></i> Submit
                        </button>
                    </div>
                </div>
            </form>
            <div id="success_msg" class="text-success font-weight-bold mt-3"></div>
        </div>
    </div>
</div>
<?php
require_once("inc/footer.php");
?>

<script>
$(document).ready(function() {

    // Fetch products based on selected category
   // Fetch products and selected times based on category
$('#category').change(function() {
    let cat_id = $(this).val();
    if (cat_id != '') {
        $.ajax({
            url: 'fetch_products.php',
            type: 'POST',
            data: { cat_id: cat_id },
            success: function(response) {
                $('#product').html(response);
                $('#timeSlots input[type=checkbox]').prop('checked', false); // reset checkboxes
            }
        });
    } else {
        $('#product').html('<option value="">-- Select Product --</option>');
        $('#timeSlots input[type=checkbox]').prop('checked', false);
    }
});

// When a product is selected, fetch already saved times
$('#product').change(function() {
    let product_id = $(this).val();
    if (product_id != '') {
        $.ajax({
            url: 'fetch_product_times.php',
            type: 'POST',
            data: { product_id: product_id },
            success: function(resp) {
                let selectedTimes = JSON.parse(resp); // array of saved times
                $('#timeSlots input[type=checkbox]').each(function() {
                    $(this).prop('checked', selectedTimes.includes($(this).val()));
                });
            }
        });
    } else {
        $('#timeSlots input[type=checkbox]').prop('checked', false);
    }
});


    // Submit time slots
    $('#addProducttimeForm').submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: 'save_product_times.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(resp) {
                let data = JSON.parse(resp);
                if (data.success) {
                    $('#success_msg').text('Time slots saved successfully!');
                } else {
                    alert('Error saving time slots');
                }
            }
        });
    });
});
</script>