
// Add Category
$("#addCatForm").on("submit", function(e) {
    e.preventDefault();

    let name = $("#name").val().trim();
    let desc = $("#desc").val().trim();
    let valid = true;

    $("#name_err").text('');
    $("#desc_err").text('');
    $("#success_msg").text('');
    
    if (name === "") {
        $("#name_err").text("Please enter category name.").addClass("text-danger");
        valid = false;
    }
    if (desc === "") {
        $("#desc_err").text("Please enter description.").addClass("text-danger");
        valid = false;
    }


    if (!valid) return;

    $.ajax({
      url: "backend/insert_category.php", // backend file
      type: "POST",
      data: { name: name, desc: desc },
      success: function(response) {
        if (response.trim() === "success") {
          $("#success_msg").text("Category added successfully!");
          $("#addCatForm")[0].reset();
        } else {
          $("#success_msg").text("Something went wrong. Please try again.");
        }
      },
      error: function() {
        $("#success_msg").text("Error connecting to server.");
      }
    });


});


// Edit Category
$("#editCatForm").on("submit", function(e) {
    e.preventDefault();

    let name = $("#name").val().trim();
    let desc = $("#desc").val().trim();
    let id = $("input[name='id']").val();
    let valid = true;

    $("#name_err, #desc_err, #success_msg").text('');

    if(name === "") { $("#name_err").text("Enter name."); valid = false; }
    if(desc === "") { $("#desc_err").text("Enter description."); valid = false; }

    if(!valid) return;

    $.ajax({
        url: "backend/update_category.php",
        type: "POST",
        data: { id: id, name: name, desc: desc },
        success: function(res) {
          if(res.trim() === "success") {
            $("#success_msg").text("Category updated successfully!");
          } else {
            $("#success_msg").text("Error updating category.");
          }
        }
      });


});


// Add Product
$("#addProductForm").on("submit", function(e) {
  e.preventDefault();


  // Clear old errors
  $("#success_msg, span.text-danger").text("");

  let valid = true;
  let category = $("#category").val().trim();
  let name = $("#name").val().trim();
  let desc = $("#desc").val().trim();
  let price = $("#price").val().trim();
  let etime = $("#etime").val().trim();
  let image = $("#image").val();

  if (category === "") { $("#cat_err").text("Select category."); valid = false; }
  if (image === "") { $("#img_err").text("Select product image."); valid = false; }
  if (name === "") { $("#name_err").text("Enter product name."); valid = false; }
  if (desc === "") { $("#desc_err").text("Enter description."); valid = false; }
  if (price === "" || isNaN(price)) { $("#price_err").text("Enter valid price."); valid = false; }
  if (etime === "") { $("#etime_err").text("Enter estimated time."); valid = false; }

  if (!valid) return;
   
  let formData = new FormData(this);

  $.ajax({
    url: "backend/insert_product.php",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function(res) {
      if (res.trim() === "success") {
        $("#success_msg").text("Product added successfully!");
        $("#addProductForm")[0].reset();
        $("#preview").html("");
      } else {
        $("#success_msg").text("Error saving product.");
      }
    },
    error: function() {
      $("#success_msg").text("Server error. Please try again.");
    }
  });

});

// Edit Product
// $("#editProductForm").on("submit", function(e) {
//   e.preventDefault();
//   alert("oka");

// });

$("#editProductForm").on("submit", function(e) {
  e.preventDefault();
  $("#success_msg, span.text-danger").text("");
  let valid = true;

  if ($("#category").val() === "") { $("#cat_err").text("Select category."); valid = false; }
  if ($("#name").val().trim() === "") { $("#name_err").text("Enter name."); valid = false; }
  if ($("#desc").val().trim() === "") { $("#desc_err").text("Enter description."); valid = false; }
  if ($("#price").val().trim() === "" || isNaN($("#price").val())) { $("#price_err").text("Enter valid price."); valid = false; }
  if ($("#etime").val().trim() === "") { $("#etime_err").text("Enter estimated time."); valid = false; }

  if (!valid) return;

  let formData = new FormData(this);
  $.ajax({
    url: "backend/update_product.php",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function(res) {
      if (res.trim() === "success") {
        $("#success_msg").text("Product updated successfully!");
      } else {
        $("#success_msg").text("Error updating product.");
      }
    }
  });
});




// Fade out errors on focus
$("#name, #desc").on("focus", function() {
  $(this).next("span").fadeOut(300, function() {
    $(this).text("").show(); // reset text after fadeout
  });
});


// Fadeout error on focus
$("input, select").on("focus", function() {
    $(this).next("span").fadeOut(300, function() {
      $(this).text("").show();
    });
});
