<?php
require_once("inc/header.php");

$id = $_GET['id'] ?? 0;
$query = $conn->prepare("SELECT * FROM `categories` WHERE `cat_id`=?");
$query->bind_param("i", $id);
$query->execute();
$result = $query->get_result();
$row = $result->fetch_assoc();

if (!$row) {
  die("Category not found!");
}

?>
<div class="page-content container container-plus">
  <div class="card acard mt-2 mt-lg-3">
    <div class="card-header">
      <h3 class="card-title text-125 text-primary-d2">
        <i class="far fa-edit text-dark-l3 mr-1"></i>
        Edit Category
      </h3>
    </div>

    <div class="card-body px-3 pb-1">

      <form action="javascript:;" method="post" id="editCatForm" class="mt-lg-3" autocomplete="off">
        <input type="hidden" name="id" value="<?= $row['cat_id'] ?>">

        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Name
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="name" id="name" class="form-control col-sm-8 col-md-6" id="id-form-field-1" value="<?= htmlspecialchars($row['name']) ?>" />
            <span id="name_err"></span>
          </div>
        </div>

        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Description
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="desc" id="desc" class="form-control col-sm-8 col-md-6" id="id-form-field-1" value="<?= htmlspecialchars($row['description']) ?>" />
            <span id="desc_err"></span>
          </div>
        </div>


        <div class="mt-5 border-t-1 bgc-secondary-l4 brc-secondary-l2 py-35 mx-n25">
          <div class="offset-md-3 col-md-9 text-nowrap">
            <button class="btn btn-info btn-bold px-4" type="submit">
              <i class="fa fa-check mr-1"></i>
              Update
            </button>

            <button class="btn btn-outline-lightgrey btn-bgc-white btn-bold ml-2 px-4" type="reset">
              <i class="fa fa-undo mr-1"></i>
              Reset
            </button>
          </div>
        </div>
      </form>

      <!-- Success message area -->
      <div id="success_msg" class="text-success font-weight-bold mt-3"></div>



    </div><!-- /.card-body -->
  </div><!-- /.card -->




</div>
<?php require_once("inc/footer.php"); ?>