<?php
require_once("inc/header.php");

$id = $_GET['id'] ?? 0;
$q = $conn->prepare("SELECT * FROM `products` WHERE `product_id`=?");
$q->bind_param("i", $id);
$q->execute();
$res = $q->get_result();
$product = $res->fetch_assoc();
if (!$product) die("Product not found.");

$cats = $conn->query("SELECT * FROM `categories` ORDER BY `name` ASC");

?>
<div class="page-content container container-plus">
  <div class="card acard mt-2 mt-lg-3">
    <div class="card-header">
      <h3 class="card-title text-125 text-primary-d2">
        <i class="far fa-edit text-dark-l3 mr-1"></i>
        Edit Product
      </h3>
    </div>

    <div class="card-body px-3 pb-1">
      <form id="editProductForm" method="post" class="mt-lg-3" enctype="multipart/form-data" autocomplete="off">

        <input type="hidden" name="id" value="<?= $product['product_id'] ?>" />


        <!-- CATEGORY -->
        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label class="mb-0">Category</label>
          </div>
          <div class="col-sm-9">
            <select name="category" id="category" class="form-control col-sm-8 col-md-6">
              <option value="">-- Select Category --</option>
              <?php while ($c = $cats->fetch_assoc()): ?>
                <option value="<?= $c['cat_id'] ?>" <?= $c['cat_id'] == $product['category_id'] ? 'selected' : '' ?>>
                  <?= htmlspecialchars($c['name']) ?>
                </option>
              <?php endwhile; ?>
            </select>
            <span id="cat_err" class="text-danger small"></span>
          </div>
        </div>


        <!-- IMAGE -->
        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Product Image
            </label>
          </div>

          <div class="col-sm-9">
            <img src="../uploads/products/<?= htmlspecialchars($product['image']) ?>" class="thumb mb-2" id="oldImg"><br>
            <input type="file" name="image" id="image" accept="image/*" class="form-control col-sm-8 col-md-6" />
            <div id="preview" class="mt-2"></div>
            <span id="img_err" class="text-danger small"></span>
          </div>
        </div>


        <!-- NAME -->
        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Name
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="name" id="name" class="form-control col-sm-8 col-md-6" value="<?= htmlspecialchars($product['product_name']) ?>" />
            <span id="name_err" class="text-danger small"></span>
          </div>
        </div>

        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Description
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="desc" id="desc" class="form-control col-sm-8 col-md-6" value="<?= htmlspecialchars($product['description']) ?>" />
            <span id="desc_err" class="text-danger small"></span>
          </div>
        </div>

        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Price
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="price" id="price" class="form-control col-sm-8 col-md-6" value="<?= htmlspecialchars($product['price']) ?>" />
            <span id="price_err" class="text-danger small"></span>
          </div>
        </div>

        <div class="form-group row">
          <div class="col-sm-3 col-form-label text-sm-right pr-0">
            <label for="id-form-field-1" class="mb-0">
              Estimated Time
            </label>
          </div>

          <div class="col-sm-9">
            <input type="text" name="etime" id="etime" class="form-control col-sm-8 col-md-6" value="<?= htmlspecialchars($product['est_time']) ?>" />
            <span id="etime_err" class="text-danger small"></span>
          </div>
        </div>



        <div class="mt-5 border-t-1 bgc-secondary-l4 brc-secondary-l2 py-35 mx-n25">
          <div class="offset-md-3 col-md-9 text-nowrap">
            <button class="btn btn-info btn-bold px-4" type="submit">
              <i class="fa fa-check mr-1"></i>
              Update Product
            </button>

            <button class="btn btn-outline-lightgrey btn-bgc-white btn-bold ml-2 px-4" type="reset">
              <i class="fa fa-undo mr-1"></i>
              Reset
            </button>
          </div>
        </div>

      </form>

      <div id="success_msg" class="text-success font-weight-bold mt-3"></div>

    </div><!-- /.card-body -->
  </div><!-- /.card -->




</div>
<?php
require_once("inc/footer.php");
?>

<script>
  $(document).ready(function() {

    // Show image preview
    $("#image").on("change", function(e) {
      const file = this.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function(evt) {
          $("#preview").html(
            `<img src="${evt.target.result}" class="img-thumbnail" width="120" style="cursor: move;">`
          );
        };
        reader.readAsDataURL(file);
      } else {
        $("#preview").html("");
      }
    });



  });
</script>