<?php require_once("inc/header.php"); ?>
<div class="page-content container container-plus">
  <div class="card acard mt-2 mt-lg-3">
    <div class="card-header">
      <h3 class="card-title text-125 text-primary-d2">
        <i class="far fa-edit text-dark-l3 mr-1"></i>
        View Categories
      </h3>
    </div>

    <div class="card-body px-3 pb-1">

      <table id="myTable" class="display" style="width:100%">
        <thead>
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Description</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $result = $conn->query("SELECT * FROM `categories` ORDER BY `cat_id` DESC");
          $i = 1;
          while ($row = $result->fetch_assoc()):
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td><?= htmlspecialchars($row['description']) ?></td>
              <td>
                <a href="edit-category.php?id=<?= $row['cat_id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                <button class="btn btn-sm btn-danger deleteBtn" data-id="<?= $row['cat_id'] ?>">Delete</button>
              </td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>




    </div><!-- /.card-body -->
  </div><!-- /.card -->




</div>
<?php require_once("inc/footer.php"); ?>

<script>
  $(document).ready(function() {

    // Delete category
    $(document).on('click', '.deleteBtn', function() {

      let id = $(this).data('id');
      if (confirm("Are you sure you want to delete this category?")) {
        $.ajax({
          url: "backend/delete_category.php",
          type: "POST",
          data: {
            id: id
          },
          success: function(res) {
            if (res.trim() === "success") {
              alert("Category deleted successfully!");
              location.reload();
            } else {
              alert("Error deleting category.");
            }
          }
        });
      }
    });


  });
</script>