<?php
require_once("inc/header.php");
include("inc/db_connect.php");

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<div class='alert alert-danger m-4'>Invalid Booking ID.</div>";
    include("inc/footer.php");
    exit;
}

$id = intval($_GET['id']);

// Fetch main booking
$bookingQuery = $conn->prepare("SELECT * FROM tbl_bookings WHERE id = ?");
$bookingQuery->bind_param("i", $id);
$bookingQuery->execute();
$booking = $bookingQuery->get_result()->fetch_assoc();

if (!$booking) {
    echo "<div class='alert alert-warning m-4'>Booking not found.</div>";
    include("inc/footer.php");
    exit;
}

// Fetch booking details
$detailsQuery = $conn->prepare("SELECT * FROM tbl_booking_details WHERE booking_id = ?");
$detailsQuery->bind_param("i", $id);
$detailsQuery->execute();
$details = $detailsQuery->get_result();
?>

<style>
body {
  background-color: #f5f7fa;
}
.booking-wrapper {
  max-width: 950px;
  margin: 40px auto;
}
.booking-card {
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.05);
  padding: 35px 40px;
  margin-bottom: 35px;
  transition: all 0.3s ease;
}
.booking-card:hover {
  box-shadow: 0 6px 20px rgba(0,0,0,0.08);
}
.booking-card h5 {
  font-weight: 700;
  color: #1f2937;
  border-bottom: 3px solid #2563eb;
  padding-bottom: 12px;
  margin-bottom: 25px;
  display: flex;
  align-items: center;
  gap: 8px;
}
.booking-card h5 i {
  color: #2563eb;
  font-size: 20px;
}
.info-label {
  font-weight: 600;
  color: #111827;
}
.info-value {
  color: #4b5563;
}
.detail-service {
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 18px 20px;
  margin-bottom: 15px;
  background: #f9fafb;
  transition: 0.2s ease;
}
.detail-service:hover {
  background: #f1f5f9;
}
.detail-service h6 {
  font-weight: 600;
  color: #1d4ed8;
}
.detail-service .price {
  font-weight: 700;
  color: #16a34a;
}
.total-box {
  font-weight: 700;
  font-size: 17px;
  color: #111827;
  text-align: right;
  margin-top: 10px;
}
.btn-back {
  background: #1d4ed8;
  color: #fff;
  border-radius: 30px;
  padding: 10px 25px;
  font-weight: 600;
  transition: 0.3s;
}
.btn-back:hover {
  background: #153eaa;
  color: #fff;
}
</style>

<div class="booking-wrapper">
  <div class="booking-card">
    <h5><i class="fas fa-info-circle"></i> Booking Information</h5>
    <div class="row">
      <div class="col-md-6">
        <p><span class="info-label">Full Name:</span> <span class="info-value"><?= htmlspecialchars($booking['full_name']) ?></span></p>
        <p><span class="info-label">Email:</span> <span class="info-value"><?= htmlspecialchars($booking['email']) ?></span></p>
        <p><span class="info-label">Phone:</span> <span class="info-value"><?= htmlspecialchars($booking['country_code'] . " " . $booking['phone']) ?></span></p>
        <p><span class="info-label">Landline:</span> <span class="info-value"><?= htmlspecialchars($booking['landline']) ?></span></p>
      </div>
      <div class="col-md-6">
        <p><span class="info-label">Address:</span> <span class="info-value"><?= htmlspecialchars($booking['address']) ?></span></p>
        <p><span class="info-label">City:</span> <span class="info-value"><?= htmlspecialchars($booking['city']) ?></span></p>
        <p><span class="info-label">ZIP:</span> <span class="info-value"><?= htmlspecialchars($booking['zip']) ?></span></p>
        <p><span class="info-label">Booking Date & Time:</span> <span class="info-value"><?= htmlspecialchars($booking['booking_date']) ?> at <?= htmlspecialchars($booking['booking_time']) ?></span></p>
      </div>
      <div class="col-12 mt-3">
        <p><span class="info-label">Gate Code:</span> <span class="info-value"><?= htmlspecialchars($booking['gate_code']) ?></span></p>
        <p><span class="info-label">Comments:</span> <span class="info-value"><?= nl2br(htmlspecialchars($booking['comments'])) ?></span></p>
      </div>
    </div>
  </div>

  <div class="booking-card">
    <h5><i class="fas fa-list-ul"></i> Services Booked</h5>
    <?php if ($details->num_rows > 0): ?>
      <?php 
      $total = 0;
      while ($row = $details->fetch_assoc()):
        $total += $row['service_price'];
      ?>
        <div class="detail-service d-flex justify-content-between align-items-center">
          <h6 class="mb-0"><?= htmlspecialchars($row['service_name']) ?></h6>
          <span class="price">$<?= number_format($row['service_price'], 2) ?></span>
        </div>
      <?php endwhile; ?>
      <div class="total-box">Total: $<?= number_format($total, 2) ?></div>
    <?php else: ?>
      <p class="text-muted">No services found for this booking.</p>
    <?php endif; ?>
  </div>

  <div class="text-start mt-4">
    <a href="view_bookings.php" class="btn btn-back"><i class="fas fa-arrow-left me-2"></i> Back to Bookings</a>
  </div>
</div>

<?php include("inc/footer.php"); ?>
