<?php require_once("inc/header.php"); ?>
<div class="page-content container container-plus">
  <div class="card acard mt-2 mt-lg-3">
    <div class="card-header">
      <h3 class="card-title text-125 text-primary-d2">
        <i class="far fa-edit text-dark-l3 mr-1"></i>
        View Bookings
      </h3>
    </div>

    <div class="card-body px-3 pb-1">

      <table id="myTable" class="display" style="width:100%">
        <thead>
          <tr>
            <th>#</th>
            <th>Fullname</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Address</th>
            <th>Booking Date</th>
            <th>Booking Time</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>

          <?php
          $sql = "SELECT * FROM `tbl_bookings`";
          $result = $conn->query($sql);
          $i = 1;
          while ($row = $result->fetch_assoc()):
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($row['full_name']) ?></td>
              <td><?= htmlspecialchars($row['email']) ?></td>
              <td><?= htmlspecialchars($row['phone']) ?></td>
              <td><?= htmlspecialchars($row['address']) ?></td>
              <td><?= htmlspecialchars($row['booking_date']) ?></td>
              <td><?= htmlspecialchars($row['booking_time']) ?></td>
              <td>
                <a href="view_booking_details.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">View Details</a>
                <!-- <button class="btn btn-sm btn-danger deleteBtn" data-id="<?= $row['id'] ?>">Delete</button> -->
              </td>
            </tr>
          <?php endwhile; ?>

        </tbody>
      </table>


    </div><!-- /.card-body -->
  </div><!-- /.card -->


</div>
<?php require_once("inc/footer.php"); ?>

<script>
  $(document).ready(function() {

    $(document).on('click', '.deleteBtn', function() {
      let id = $(this).data('id');
      if (confirm("Are you sure you want to delete this product?")) {
        $.ajax({
          url: "backend/delete_product.php",
          type: "POST",
          data: {
            id: id
          },
          success: function(res) {
            if (res.trim() === "success") {
              alert("Product deleted successfully!");
              location.reload();
            } else {
              alert("Error deleting product.");
            }
          }
        });
      }
    });


  });
</script>