<?php 
include ('inc/db_connect.php');
// Get all categories
$catRes = $conn->query("SELECT * FROM `categories` ORDER BY `name` ASC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Soot Busters</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link rel="stylesheet" href="https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css" />
    <link rel="stylesheet" href="https://cdn.rawgit.com/michalsnik/aos/1.0.1/dist/aos.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.0.2/css/bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="stylesheet" href="assets/css/responsive.css" />
</head>

<body>
    <div class="row align-items-center">
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-5">
            <div class="web-book-sec">
                <img class="logo" src="assets/images/book-logo.png" alt="book logo">
                <p>Proudly serving the heart of Amador and Calaveras Counties.</p>
                <!-- <ul>
                        <li><img src="assets/images/google-logo.png" alt="google logo"></li>
                        <li><strong>4.8</strong>480 Google reviews</li>
                    </ul>
                    <img class="rating" src="assets/images/rating.png" alt="rating star"> -->

                <div id="cart-summary" class="summary-box mt-3"
                    style="<?= empty($_SESSION['cart']) ? 'display:none;' : '' ?>">
                    <h5>Summary</h5>
                    <hr>
                    <ul id="summary-list">
                        <?php
                            $total = 0;
                            foreach ($_SESSION['cart'] as $item):
                                $total += $item['price'];
                            ?>
                        <li class="d-flex justify-content-between align-items-center">
                            <span><?= htmlspecialchars($item['name']) ?></span>
                            <span>$<?= number_format($item['price'], 2) ?></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <hr>
                    <div class="total mt-2">
                        <strong>Total:</strong> $<span id="total-amount"><?= number_format($total, 2) ?></span>
                    </div>
                </div>

                <button id="bookNowBtn" class="btn btn-primary w-btn">Book Now</button>
            </div>
        </div>
    </div>
    <section class="main-page-row">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-9 col-lg-8">
                    <section class="services-row" id="services-row">
                        <div class="services-inner-row booking-page-row">
                            <h4><a href="./"><i class="fa fa-angle-left" aria-hidden="true"></i> Select a Service</a>
                            </h4>
                            <div class="w-sec services-sec">
                                <h2>Services</h2>
                                <p>Here’s a breakdown of what we offer:</p>

                                 <div class="accordion" id="accordionExample">
                                <?php while ($cat = $catRes->fetch_assoc()): ?>
                                <?php
                                    $catId = $cat['cat_id'];
                                    $prodRes = $conn->query("SELECT * FROM products WHERE category_id = $catId");
                                    if ($prodRes->num_rows == 0) continue;
                                    ?>
                                <div class="accordion-item">
                                    <h3 class="accordion-header" id="heading<?= $catId ?>">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse<?= $catId ?>"
                                            aria-expanded="false" aria-controls="collapse<?= $catId ?>">
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </button>
                                    </h3>

                                    <div id="collapse<?= $catId ?>" class="accordion-collapse collapse"
                                        aria-labelledby="heading<?= $catId ?>" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php while ($prod = $prodRes->fetch_assoc()):
                                                    $isAdded = isset($_SESSION['cart'][$prod['product_id']]);
                                                ?>
                                            <div class="services-box-sec" data-id="<?= $prod['product_id'] ?>"
                                                data-name="<?= htmlspecialchars($prod['product_name']) ?>"
                                                data-price="<?= $prod['price'] ?>" data-est="<?= $prod['est_time'] ?>">

                                                <img src="uploads/products/<?= htmlspecialchars($prod['image']) ?>"
                                                    alt="service image">

                                                <div class="text">
                                                    <h4><?= htmlspecialchars($prod['product_name']) ?></h4>
                                                    <ul class="d-flex align-items-center flex-wrap" style="gap:10px;">
                                                        <li><a href="javascript:;" class="show-detail">Details</a></li>
                                                        <li><a href="javascript:;" class="hide-detail d-none">Hide
                                                                details</a></li>
                                                     
                                                        <li>.</li>
                                                        <li><?= htmlspecialchars($prod['price']) ?></li>
                                                        <li>
                                                            <button
                                                                class="btn btn-sm add-to-cart <?= $isAdded ? 'btn-primary' : 'btn-outline-primary' ?>">
                                                                <i
                                                                    class="fa <?= $isAdded ? 'fa-check' : 'fa-plus' ?>"></i>
                                                            </button>
                                                        </li>
                                                        <!-- <li>
                                                                    <button class="btn btn-sm btn-success add-to-cart"><i class="fa fa-plus"></i></button>
                                                                    <span class="cart-status ml-2"></span>
                                                                </li> -->
                                                    </ul>
                                                    <div class="target d-none">
                                                        <p><?= nl2br($prod['description']) ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>

                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.0/js/bootstrap.min.js"></script>
    <script src="https://cdn.rawgit.com/michalsnik/aos/1.0.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
    <script src="assets/js/custom.js"></script>
</body>

</html>
<script>
document.getElementById('bookNowBtn').addEventListener('click', function() {
    fetch('check_cart.php')
        .then(response => response.json())
        .then(data => {
            if (data.hasItems) {
                window.location.href = 'book_service.php';
            } else {
                window.location.href = 'book.php';
            }
        });
});
</script>
<script>
$(document).ready(function() {
    $(".add-to-cart").click(function() {
        const btn = $(this);
        const box = btn.closest(".services-box-sec");
        const id = box.data("id");
        const name = box.data("name");
        const price = box.data("price");

        const isAdded = btn.hasClass("btn-primary");
        const action = isAdded ? "remove" : "add";

        $.ajax({
            url: "cart_action.php", // same file
            type: "POST",
            data: {
                action,
                id,
                name,
                price
            },
            dataType: "json",
            success: function(res) {
                console.log(res);
                if (res.success) {

                    // location.reload();

                    // update summary live here
                    updateSummary(res.cart);

                    // toggle button icon
                    if (action === "add") {
                        btn.removeClass("btn-outline-primary")
                            .addClass("btn-primary")
                            .html('<i class="fa fa-check"></i>');

                    } else {
                        btn.removeClass("btn-primary")
                            .addClass("btn-outline-primary")
                            .html('<i class="fa fa-plus"></i>');
                    }
                }

            }
        });
    });

    function updateSummary(cart) {
        const list = $("#summary-list");
        const totalEl = $("#total-amount");
        list.empty();

        let total = 0;
        $.each(cart, function(id, item) {
            list.append(`
                    <li class="d-flex justify-content-between align-items-center">
                        <span>${item.name}</span>
                        <span>$${parseFloat(item.price).toFixed(2)}</span>
                    </li>
                `);
            total += parseFloat(item.price);
        });

        totalEl.text(total.toFixed(2));

        // If cart empty → hide summary box
        if (Object.keys(cart).length === 0) {
            $("#cart-summary").fadeOut(200);
        } else {
            $("#cart-summary").fadeIn(200);
        }
    }

    // Show details
    $(".show-detail").click(function() {
        let parent = $(this).closest(".text");
        parent.find(".target").slideDown();
        parent.find(".show-detail").addClass("d-none");
        parent.find(".hide-detail").removeClass("d-none");
    });

    // Hide details
    $(".hide-detail").click(function() {
        let parent = $(this).closest(".text");
        parent.find(".target").slideUp();
        parent.find(".hide-detail").addClass("d-none");
        parent.find(".show-detail").removeClass("d-none");
    });

});
</script>
          <script>
                    $(document).on('click', '.show-detail', function () {
    const parent = $(this).closest('.services-box-sec');
    parent.find('.target').removeClass('d-none');
    parent.find('.show-detail').addClass('d-none');
    parent.find('.hide-detail').removeClass('d-none');
});

$(document).on('click', '.hide-detail', function () {
    const parent = $(this).closest('.services-box-sec');
    parent.find('.target').addClass('d-none');
    parent.find('.show-detail').removeClass('d-none');
    parent.find('.hide-detail').addClass('d-none');
});

                </script>