<?php
include("inc/header.php");
session_start();

if (empty($_SESSION['cart'])) {
    header("Location: book.php");
    exit;
}

$cart = $_SESSION['cart'];
$total = 0;
foreach ($cart as $item) {
    $total += $item['price'];
}
?>


<!--<section class="banner-row inner-banner-row">-->
<!--    <div class="container">-->
<!--        <div class="banner-sec inner-banner-sec text-center">-->
<!--            <h1>Book Your Service</h1>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->


<section class="book-service-section py-5" style="background:#f7f7f7; margin-top: 110px;">
    <div class="container">
        <div class="row justify-content-center mb-4">
            <div class="col-12">
                <a href="book.php" class="text-dark text-decoration-none fw-medium"
                    style="font-size:16px; font-weight:800;">
                    ← Select a time
                </a>
            </div>
        </div>

        <div class="row g-4 align-items-start">
            <!-- Left: Calendar + Time -->
            <div class="col-lg-8">
                <div class="booking-card bg-white p-4 rounded-4 shadow-sm">
                    <h3 class="fw-semibold mb-4" style="font-size:22px;">
                        <?= htmlspecialchars(implode(', ', array_column($cart, 'name'))) ?>
                    </h3>

                    <div class="calendar-time-grid">
                        <!-- Calendar -->
                        <div class="calendar-container">
                            <div id="calendar"></div>
                            <small class="text-muted d-block mt-2">
                                Time zone (America/Los_Angeles)
                            </small>
                        </div>

                        <!-- Time Slots -->
                        <div class="time-slot-container">
                            <p id="selected-date" class="fw-semibold mb-3 text-secondary" style="display:none;"></p>
                            <?php 
                            foreach($cart as $item){
    $prod_id = $item['product_id'] ?? null;  // <-- safe
    if(!$prod_id) continue;

    $res = $conn->query("SELECT time_slot FROM product_times WHERE product_id=$prod_id ORDER BY id ASC");
    $times = [];
    if($res){
        while($row = $res->fetch_assoc()){
            $times[] = $row['time_slot'];
        }
    }
    $all_times[$prod_id] = $times;
}

                            ?>
                           <div class="time-slot-grid" style="display:none;">
    <?php
    // Merge all time slots from all products
    $merged_times = [];
    foreach ($all_times as $prod_id => $times) {
        $merged_times = array_merge($merged_times, $times);
    }
    $merged_times = array_unique($merged_times); // remove duplicates
    sort($merged_times); // optional: sort by time

    if (!empty($merged_times)) {
        foreach ($merged_times as $time) {
            echo '<button class="time-btn">'. htmlspecialchars($time) .'</button>';
        }
    } else {
        echo '<p class="text-muted">No time slots available.</p>';
    }
    ?>
</div>



                            <button id="continue-btn" class="btn btn-primary mt-4 fw-semibold px-4 py-2"
                                style="display:none; border-radius:8px;">
                                Continue →
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right: Company + Summary -->
            <div class="col-lg-4">
                <div class="company-box bg-white shadow-sm rounded-4 p-4 mb-4 text-center">
                    <img src="assets/images/logo.png" alt="Company Logo" style="max-width:120px;" class="mb-3">
                    <h5 class="fw-semibold mb-1">Soot Busters</h5>
                    <p class="small text-muted mb-0">Proudly serving the heart of Amador and Calaveras Counties.</p>
                </div>

                <div class="summary-box bg-white shadow-sm rounded-4 p-4">
                    <h5 class="fw-semibold mb-3">Summary</h5>
                    <ul class="list-unstyled mb-3">
                        <?php foreach ($cart as $item): ?>
                        <li class="d-flex justify-content-between border-bottom py-2">
                            <div>
                                <div><?= htmlspecialchars($item['name']) ?></div>
                            </div>
                            <div>$<?= number_format($item['price'], 2) ?></div>

                        </li>
                        <?php if (!empty($item['est_time'])): ?>
                        <small class="text-muted d-block mt-1 text-center">
                            <i class="fa fa-clock-o"></i> Prep time: <?= htmlspecialchars($item['est_time']) ?>
                        </small>
                        <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                    <div class="d-flex justify-content-between fw-semibold">
                        <span>Total to pay</span>
                        <span>$<?= number_format($total, 2) ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Flatpickr Calendar -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
function replaceDisabledDays() {
    document.querySelectorAll('.flatpickr-day.disabled').forEach(day => {
        day.innerHTML = '<span style="opacity:0.4;">–</span>';
    });
}

// Observe DOM changes to keep dashes visible
const observer = new MutationObserver(() => replaceDisabledDays());
observer.observe(document.body, {
    childList: true,
    subtree: true
});

document.addEventListener("DOMContentLoaded", function() {
    let selectedDate = null;
    let selectedTime = null;

    const calendar = flatpickr("#calendar", {
        inline: true,
        dateFormat: "Y-m-d",
        minDate: "today",
        disable: [date => date.getDay() === 0], // disable Sundays
        onReady: function(selectedDates, dateStr, instance) {
            replaceDisabledDays();
            const today = new Date();
            instance.setDate(today, true);
            showTimeSlots(today);
        },
        onChange: function(selectedDates) {
            if (selectedDates.length) {
                selectedDate = selectedDates[0];
                showTimeSlots(selectedDates[0]);
            }
        }
    });

    function showTimeSlots(date) {
        const dateEl = document.getElementById('selected-date');
        const timeGrid = document.querySelector('.time-slot-grid');
        const formatted = date.toLocaleDateString('en-US', {
            weekday: 'long',
            day: 'numeric',
            month: 'long'
        });
        dateEl.textContent = formatted;
        dateEl.style.display = 'block';
        timeGrid.style.display = 'flex';
    }

    document.querySelectorAll('.time-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.time-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            selectedTime = this.textContent;

            if (selectedTime && selectedDate) {
                const formattedDate = selectedDate.toISOString().split('T')[0];
                // Redirect with both date & time in the URL
                const serviceName = "<?php echo urlencode($item['name'] ?? ''); ?>";
                const servicePrice = "<?php echo urlencode($item['price'] ?? ''); ?>";

                fetch("save_booking_session.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            date: selectedDate.getFullYear() + '-' +
                                String(selectedDate.getMonth() + 1).padStart(2,
                                    '0') + '-' +
                                String(selectedDate.getDate()).padStart(2, '0'),
                            time: selectedTime,
                            name: "<?php echo addslashes(implode(', ', array_column($cart, 'name'))); ?>",
                            price: "<?php echo $total; ?>"
                        })
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            window.location.href = "guest_details.php";
                        } else {
                            alert("Something went wrong, please try again.");
                        }
                    });
            }
        });
    });
});
</script>





<?php include("inc/footer.php"); ?>