<?php
session_start();

// Initialize cart
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Handle actions
if (isset($_POST['action'])) {
    $id = $_POST['id'];           // this comes from JS (data-id)
    $name = $_POST['name'];
    $price = floatval($_POST['price']);
    $est_time = $_POST['est_time'] ?? '60 mins';

    if ($_POST['action'] === 'add') {
        // Save product_id explicitly but keep other keys
        $_SESSION['cart'][$id] = [
            'product_id' => $id,
            'name' => $name,
            'price' => $price,
            'est_time' => $est_time
        ];
    } elseif ($_POST['action'] === 'remove') {
        unset($_SESSION['cart'][$id]);
    }

    echo json_encode(['success' => true, 'cart' => $_SESSION['cart']]);
    exit;
}

echo json_encode(['success' => false, 'message' => 'Invalid request']);
exit;
