<?php
include("inc/header.php");
session_start();


$booking = $_SESSION['selected_booking'] ?? null;
$services = $booking['services'] ?? [];
$total = 0;
foreach ($services as $srv) $total += $srv['price'];




if (!$booking) {
    header("Location: book-service.php");
    exit;
}

$selectedDate = $booking['date'];
$selectedTime = $booking['time'];
// Format date properly
$formattedDate = date("l, F j, Y", strtotime($selectedDate));
?>





<!--<section class="banner-row inner-banner-row">-->
<!--    <div class="container">-->
<!--        <div class="banner-sec inner-banner-sec text-center">-->
<!--            <h1>Your Details</h1>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->

<section class="guest-form-page py-5" style="margin-top:110px; background:#f7f7f7;">
    <div class="container">
        <div class="row justify-content-center">

            <!-- Left Column -->
            <div class="col-lg-7 mb-4">
                <div class="guest-form-box p-5 bg-white rounded-4 shadow-sm">
                    <form id="bookingForm" class="guest-form">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Full Name *</label>
                                <input type="text" name="full_name" class="form-control rounded-pill"
                                    placeholder="Enter Fullname">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Email *</label>
                                <input type="email" name="email" class="form-control rounded-pill"
                                    placeholder="Enter Email">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Phone *</label>
                                <input id="phone" type="tel" name="phone" class="form-control rounded-pill">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Landline *</label>
                                <input type="text" name="landline" class="form-control rounded-pill"
                                    placeholder="Enter Landline">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Cell Phone *</label>
                                <input type="text" name="cellphone" class="form-control rounded-pill"
                                    placeholder="Enter Cellphone">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Gate Code</label>
                                <input type="text" name="gate_code" class="form-control rounded-pill"
                                    placeholder="Enter Gate code">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Address *</label>
                                <input type="text" name="address" class="form-control rounded-pill"
                                    placeholder="Enter Address">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Street *</label>
                                <input type="text" name="street" class="form-control rounded-pill"
                                    placeholder="Enter Street">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">City *</label>
                                <input type="text" name="city" class="form-control rounded-pill"
                                    placeholder="Enter City">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">ZIP Code *</label>
                                <input type="text" name="zip" class="form-control rounded-pill"
                                    placeholder="Enter Zip code">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold">Comments</label>
                                <textarea name="comments" rows="2" class="form-control rounded-4"
                                    placeholder="Enter Comments"></textarea>
                            </div>
                            <input type="hidden" name="date" value="<?= htmlspecialchars($selectedDate) ?>">
                            <input type="hidden" name="time" value="<?= htmlspecialchars($selectedTime) ?>">

                            <?php foreach ($services as $srv): ?>
                            <input type="hidden" name="services[]" value="<?= htmlspecialchars($srv['name']) ?>">
                            <input type="hidden" name="prices[]" value="<?= htmlspecialchars($srv['price']) ?>">
                            <?php endforeach; ?>

                            <div class="col-12 text-start mt-3">
                                <button type="submit"
                                    class="btn btn-primary confirm-btn px-4 py-2 rounded-pill">Confirm</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>

            <!-- Right Column -->
            <div class="col-lg-5">
                <div class="business-box bg-white p-4 rounded-4 shadow-sm mb-4 text-center">
                    <img src="assets/images/logo.png" alt="Company Logo" style="max-width:120px;" class="mb-3">
                    <h5 class="fw-semibold mb-1">Soot Busters</h5>
                    <p class="small text-muted mb-0">Proudly serving the heart of Amador and Calaveras Counties.</p>
                </div>

                <div class="summary-box bg-white p-4 rounded-4 shadow-sm">
                    <h6 class="fw-bold mb-3">Summary</h6>

                    <p class="mb-1"><?= htmlspecialchars($selectedTime ?: 'No time selected') ?></p>
                    <p class="text-muted mb-1"><?= htmlspecialchars($formattedDate) ?></p>

                    <?php foreach ($services as $srv): ?>
                    <p class="mb-1 service_name">
                        <?= htmlspecialchars($srv['name']) ?>
                        <span class="float-end">$<?= number_format($srv['price'], 2) ?></span>
                    </p>
                    <?php endforeach; ?>
                    <hr>
                    <p class="fw-bold mb-0">
                        Total to pay <span class="float-end">$<?= number_format($total, 2) ?></span>
                    </p>
                </div>

            </div>

        </div>
    </div>
</section>

<?php include("inc/footer.php"); ?>
<script>
$(document).ready(function() {
    const input = document.querySelector("#phone");

    // Initialize with all countries and search enabled
    const iti = window.intlTelInput(input, {
        initialCountry: "us", // Default to Pakistan
        separateDialCode: true,
        autoPlaceholder: "polite",
        nationalMode: false,
        dropdownContainer: document.body, // ensures dropdown is not cut off
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js"
    });

    // On form submit, add hidden input for country code
    $("#bookingForm").on("submit", function() {
        const dialCode = iti.getSelectedCountryData().dialCode;
        const number = input.value.trim();
        $("<input>").attr({
            type: "hidden",
            name: "country_code",
            value: "+" + dialCode
        }).appendTo("#bookingForm");
        input.value = number;
    });
});
</script>


<script>
$(function() {
    const fields = {
        full_name: "Enter your full name",
        email: "Enter your email address",
        phone: "Enter your phone number",
        landline: "Enter your landline number",
        cellphone: "Enter your cell phone number",
        gate_code: "Enter gate code",
        address: "Enter your address",
        street: "Enter your street name",
        city: "Enter your city",
        zip: "Enter your ZIP code",
        comments: "Enter comments"
    };

    // Remove error on focus or typing
    $(document).on("focus input", "#bookingForm input, #bookingForm textarea, #bookingForm select", function() {
        $(this).removeClass("is-invalid");
        $(this).next(".invalid-feedback").remove();
    });

    $("#bookingForm").on("submit", function(e) {
        e.preventDefault();

        let isValid = true;

        // Remove old errors
        $(".invalid-feedback").remove();
        $(".is-invalid").removeClass("is-invalid");

        // Validate each required field
        $.each(fields, function(name, message) {
            const field = $(`[name='${name}']`);
            if ($.trim(field.val()) === "") {
                field.addClass("is-invalid");
                field.after(`<div class="invalid-feedback d-block">${message}</div>`);
                isValid = false;
            }
        });

        // Email format validation
        const email = $("input[name='email']").val();
        const emailPattern = /^[^ ]+@[^ ]+\.[a-z]{2,}$/;
        if (email && !emailPattern.test(email)) {
            const emailField = $("input[name='email']");
            emailField.addClass("is-invalid");
            emailField.after('<div class="invalid-feedback d-block">Please enter a valid email</div>');
            isValid = false;
        }

        if (!isValid) return; // Stop if invalid

        // Proceed with AJAX submit
        $.ajax({
            url: "submit_booking.php",
            type: "POST",
            data: $("#bookingForm").serialize(),
            dataType: "json",
            beforeSend: function() {
                $(".confirm-btn").prop("disabled", true).text("Submitting...");
            },
            success: function(response) {
                if (response.success) {
                    $(".confirm-btn").prop("disabled", false).text("Confirm");
                    $("#bookingForm")[0].reset();
                    toastr.success("Booking confirmed successfully!", "Success");

                    // 🧹 Hide or clear summary section visually
                    $(".summary-box").fadeOut(500, function() {
                        $(this).html(
                            "<p class='text-center text-muted'>No items selected</p>"
                        ).fadeIn(300);
                    });
                } else {
                    toastr.error(response.message || "Something went wrong", "Error");
                }
            },

            error: function() {
                $(".confirm-btn").prop("disabled", false).text("Confirm");
                toastr.error("Server error. Please try again.", "Error");
            }
        });
    });
});
</script>