    <footer class="footer-row">
        <div class="footer-sec">
            <img src="assets/images/footer-logo.png" alt="footer logo">
            <ul>
                <li><a href="#banner-row">Home</a></li>
                <li><a href="#services-row">Services</a></li>
                <li><a href="#about-row">About us</a></li>
                <li><a href="#testimonials-row">Testimonials</a></li>
                <li><a href="#contact-row">Contact Us</a></li>
                <li><a href="login.php">Login</a></li>
            </ul>
            
        </div>
    </footer>
    <div class="copyright-sec">
        <p>powered by <a href="https://webdesignsigma.com/" target="_blank">web design sigma</a></p>
    </div>
    </div>
    </div>
    </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.0/js/bootstrap.min.js"></script>
    <script src="https://cdn.rawgit.com/michalsnik/aos/1.0.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <!-- Include Toastr JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- intl-tel-input JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
    </body>

    </html>

    <script>
$(document).ready(function() {
    $(".add-to-cart").click(function() {
        const btn = $(this);
        const box = btn.closest(".services-box-sec");
        const id = box.data("id");         // <-- this is product_id
        const name = box.data("name");
        const price = box.data("price");
        const est_time = box.data("est");

        const isAdded = btn.hasClass("btn-primary");
        const action = isAdded ? "remove" : "add";

        $.ajax({
            url: "cart_action.php",
            type: "POST",
            data: {
                action,
                id,           // send the same product_id
                name,
                price,
                est_time
            },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    updateSummary(res.cart);

                    if (action === "add") {
                        btn.removeClass("btn-outline-primary")
                            .addClass("btn-primary")
                            .html('<i class="fa fa-check"></i>');
                    } else {
                        btn.removeClass("btn-primary")
                            .addClass("btn-outline-primary")
                            .html('<i class="fa fa-plus"></i>');
                    }
                }
            }
        });
    });

    function updateSummary(cart) {
        const list = $("#summary-list");
        const totalEl = $("#total-amount");
        list.empty();

        let total = 0;
        $.each(cart, function(id, item) {
            list.append(`
                <li class="mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>${item.name}</span>
                        <span>$${parseFloat(item.price).toFixed(2)}</span>
                    </div>
                    ${item.est_time ? `<small class="text-muted d-block mt-1 text-center"><i class="fa fa-clock-o"></i> Prep time: ${item.est_time}</small>` : ''}
                </li>
            `);
            total += parseFloat(item.price);
        });

        totalEl.text(total.toFixed(2));

        if (Object.keys(cart).length === 0) {
            $("#cart-summary").fadeOut(200);
        } else {
            $("#cart-summary").fadeIn(200);
        }
    }




    // Show details
    $(".show-detail").click(function() {
        let parent = $(this).closest(".text");
        parent.find(".target").slideDown();
        parent.find(".show-detail").addClass("d-none");
        parent.find(".hide-detail").removeClass("d-none");
    });

    // Hide details
    $(".hide-detail").click(function() {
        let parent = $(this).closest(".text");
        parent.find(".target").slideUp();
        parent.find(".hide-detail").addClass("d-none");
        parent.find(".show-detail").removeClass("d-none");
    });

});
    </script>