<?php
include("inc/header.php");
session_start();

// unset($_SESSION['cart']);

// // Initialize cart session if not exists
// if (!isset($_SESSION['cart'])) {
//     $_SESSION['cart'] = [];
// }

// // Handle AJAX cart update requests
// if (isset($_POST['action'])) {
//     $id = $_POST['id'];
//     $name = $_POST['name'];
//     $price = floatval($_POST['price']);

//     if ($_POST['action'] === 'add') {
//         $_SESSION['cart'][$id] = ['name' => $name, 'price' => $price];
//     } elseif ($_POST['action'] === 'remove') {
//         unset($_SESSION['cart'][$id]);
//     }

//     // Return current cart
//     echo json_encode(['success' => true, 'cart' => $_SESSION['cart']]);
//     exit;
// }


// Get all categories
$catRes = $conn->query("SELECT * FROM `categories` ORDER BY `name` ASC");

?>

<section class="banner-row" id="banner-row">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-xs-12 col-sm-12 col-md-6 col-lg-7">
                <div class="banner-sec">
                    <h3>Keep Your Home Safe & Warm..</h3>
                    <h1>Professinal Chimney Sweeping Services</h1>
                    <ul>
                        <li>• Remove dangerous creosote buildup</li>
                        <li>• Prevent chimney fires</li>
                        <li>• Improve heating efficiency</li>
                        <li>• Reliable, friendly service</li>

                    </ul>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-6 col-lg-5">
                <div class="web-book-sec">
                    <img class="logo" src="assets/images/book-logo.png" alt="book logo">
                    <p>Proudly serving the heart of Amador and Calaveras Counties.</p>
                    <!-- <ul>
                        <li><img src="assets/images/google-logo.png" alt="google logo"></li>
                        <li><strong>4.8</strong>480 Google reviews</li>
                    </ul>
                    <img class="rating" src="assets/images/rating.png" alt="rating star"> -->

                    <div id="cart-summary" class="summary-box mt-3"
                        style="<?= empty($_SESSION['cart']) ? 'display:none;' : '' ?>">
                        <h5>Summary</h5>
                        <hr>
                        <ul id="summary-list">
                            <?php
        $total = 0;
        foreach ($_SESSION['cart'] as $item):
            $total += $item['price'];
        ?>
                            <li class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span><?= htmlspecialchars($item['name']) ?></span>
                                    <span>$<?= number_format($item['price'], 2) ?></span>
                                </div>
                                <?php if (!empty($item['est_time'])): ?>
                                <small class="text-muted d-block mt-1 text-center">
                                    <i class="fa fa-clock-o"></i> Prep time: <?= htmlspecialchars($item['est_time']) ?>
                                </small>
                                <?php endif; ?>

                            </li>
                            <?php endforeach; ?>
                        </ul>
                        <hr>
                        <div class="total mt-2">
                            <strong>Total:</strong> $<span id="total-amount"><?= number_format($total, 2) ?></span>
                        </div>
                    </div>


                    <button id="bookNowBtn" class="btn btn-primary w-btn">Book Now</button>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="main-page-row">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-9 col-lg-8">
                <section class="services-row">
                    <div class="services-inner-row">
                        <div class="w-sec policy-sec" id="services-row">
                            <h2>Our Booking Policy</h2>
                            <p>We require advance booking to ensure we allocate enough time for a thorough inspection or sweep. Appointments can be scheduled via phone or our online form.</p>
                            <p>Cancellations must be made at least <b>24 hours in advance</b> to avoid a cancellation fee. Travel and access to chimneys on steep roofs may incur an additional service charge.</p>
                            <a href="book.php"><button class="btn btn-primary w-btn">Book Now</button></a>
                        </div>
                        <div class="w-sec services-sec">
                            <h2>Services</h2>
                            <p>Here’s a breakdown of what we offer:</p>

                            <div class="accordion" id="accordionExample">
                                <?php while ($cat = $catRes->fetch_assoc()): ?>
                                <?php
                                    $catId = $cat['cat_id'];
                                    $prodRes = $conn->query("SELECT * FROM products WHERE category_id = $catId");
                                    if ($prodRes->num_rows == 0) continue;
                                    ?>
                                <div class="accordion-item">
                                    <h3 class="accordion-header" id="heading<?= $catId ?>">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse<?= $catId ?>"
                                            aria-expanded="false" aria-controls="collapse<?= $catId ?>">
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </button>
                                    </h3>

                                    <div id="collapse<?= $catId ?>" class="accordion-collapse collapse"
                                        aria-labelledby="heading<?= $catId ?>" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php while ($prod = $prodRes->fetch_assoc()):
                                                    $isAdded = isset($_SESSION['cart'][$prod['product_id']]);
                                                ?>
                                            <div class="services-box-sec" data-id="<?= $prod['product_id'] ?>"
                                                data-name="<?= htmlspecialchars($prod['product_name']) ?>"
                                                data-price="<?= $prod['price'] ?>" data-est="<?= $prod['est_time'] ?>">

                                                <img src="uploads/products/<?= htmlspecialchars($prod['image']) ?>"
                                                    alt="service image">

                                                <div class="text">
                                                    <h4><?= htmlspecialchars($prod['product_name']) ?></h4>
                                                    <ul class="d-flex align-items-center flex-wrap" style="gap:10px;">
                                                        <li><a href="javascript:;" class="show-detail">Details</a></li>
                                                        <li><a href="javascript:;" class="hide-detail d-none">Hide
                                                                details</a></li>
                                                     
                                                        <li>.</li>
                                                        <li><?= htmlspecialchars($prod['price']) ?></li>
                                                        <li>
                                                            <button
                                                                class="btn btn-sm add-to-cart <?= $isAdded ? 'btn-primary' : 'btn-outline-primary' ?>">
                                                                <i
                                                                    class="fa <?= $isAdded ? 'fa-check' : 'fa-plus' ?>"></i>
                                                            </button>
                                                        </li>
                                                        <!-- <li>
                                                                    <button class="btn btn-sm btn-success add-to-cart"><i class="fa fa-plus"></i></button>
                                                                    <span class="cart-status ml-2"></span>
                                                                </li> -->
                                                    </ul>
                                                    <div class="target d-none">
                                                        <p><?= nl2br($prod['description']) ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>

                        </div>
                    </div>
                </section>
                <section class="about-row" id="about-row">
                    <div class="w-sec about-sec">
                        <h2>About Soot Busters</h2>
                        <p>At Soot Busters, we specialize in making your home safer, more efficient, and fire-risk free. As your local chimney cleaning and inspection expert, we’re dedicated to serving homeowners across Amador and Calaveras Counties.</p>
                        <h3>What sets us apart:</h3>
                        <ul>
                            <li>• Focus on wood-burning stoves, pellet stoves, and fireplace inserts.</li>
                            <li>• Skilled, certified technicians who use professional-grade tools and rotary brushes.</li>
                            <li>• Thorough inspections (Level 1) with a written safety report.</li>
                            <li>• Transparent pricing and no hidden fees.</li>
                            <li>• Commitment to customer satisfaction and long-term safety.</li>
                        </ul>
                        <p>When you choose Soot Busters, you're choosing peace of mind — knowing your heating system is clean, safe, and running efficiently.</p>
                        
                    </div>
                </section>
                <section class="testimonials-row" id="testimonials-row">
                    <div class="w-sec testimonials-head">
                        <h2>Our Testimonials</h2>
                    </div>
                    <div class="testimonials-slider">
                        <div id="testimonials-carousel" class="owl-carousel">
                            <div class="item">
                                <div class="testimonilas-sec">
                                    <div class="user-box">
                                        <img decoding="async" src="assets/images/client-img1.png">
                                        <div class="text">
                                            <h4>amara collins</h4>
                                            <h5>Homeowner</h5>
                                        </div>
                                    </div>
                                    <p>“Soot Busters did a fantastic job cleaning our old wood stove — they were professional, prompt, and left everything spotless. I feel so much safer now.”</p>
                                    <div class="rating-box">
                                        <ul>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                        </ul>
                                        <img decoding="async" src="assets/images/quote-img.png">
                                    </div>
                                </div>
                            </div>
                            <div class="item">
                                <div class="testimonilas-sec">
                                    <div class="user-box">
                                        <img decoding="async" src="assets/images/avatar-1.png">
                                        <div class="text">
                                            <h4>John P</h4>
                                            <h5>Calaveras County</h5>
                                        </div>
                                    </div>
                                    <p style="padding-bottom:58px;">“Their inspection caught a potential hazard we never noticed. Thanks to them, I now sleep better knowing our chimney is clean.”</p>
                                    <div class="rating-box">
                                        <ul>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                            <li><i class="fa fa-star"></i></li>
                                        </ul>
                                        <img decoding="async" src="assets/images/quote-img.png">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="gallery-row" id="gallery-row">
                    <div class="row">
                        <div class=" col-3">
                            <div class="gallery-sec">
                                <img class="large" src="assets/images/gallery-img1.png" alt="gallery image">
                            </div>
                            <div class="gallery-sec">
                                <img class="rectangle" src="assets/images/gallery-img5.png" alt="gallery image">
                            </div>
                        </div>
                        <div class=" col-6">
                            <div class="gallery-sec">
                                <div class="gallery-flx">
                                    <img src="assets/images/gallery-img2.png" alt="gallery image">
                                    <img src="assets/images/gallery-img3.png" alt="gallery image">
                                </div>
                            </div>
                            <div class="gallery-sec">
                                <img class="lrg-rectangle" src="assets/images/gallery-img6.png" alt="gallery image">
                            </div>
                        </div>
                        <div class=" col-3">
                            <div class="gallery-sec">
                                <img class="rectangle" src="assets/images/gallery-img4.png" alt="gallery image">
                            </div>
                            <div class="gallery-sec">
                                <img class="large" src="assets/images/gallery-img7.png" alt="gallery image">
                            </div>
                        </div>
                    </div>
                </section>
                <section class="contact-row" id="contact-row">
                    <div class="w-sec contact-sec">
                        <h3>contact info</h3>
                        <h2>Our Service area</h2>
                        <p style="margin-bottom:0px;">We proudly serve the following regions:</p>
                        <ul>
                            <li>•	Amador County</li>
                            <li>•	Calaveras County</li>
                        </ul>
                        <p>If you're outside our normal service area, contact us — we may still be able to accommodate depending on the job.</p>
                        <div class="contact-icon-txt">
                            <img src="assets/images/phone-icon.png" alt="contact icon">
                            <div class="text">
                                <h4>Phone</h4>
                                <a href="tel:209-660-9627">209-660-9627</a>
                            </div>
                        </div>
                        <div class="contact-icon-txt">
                            <img src="assets/images/envelope-icon.png" alt="contact icon">
                            <div class="text">
                                <h4>Email</h4>
                                <a href="mailto:nickademussomers@gmail.com">nickademussomers@gmail.com</a>
                            </div>
                        </div>
                        <div class="contact-icon-txt">
                            <img src="assets/images/envelope-icon2.png" alt="contact icon">
                            <div class="text">
                                <h4>Careers</h4>
                                <a href="mailto:careersnickademussomers@gmail.com">careersnickademussomers@gmail.com</a>
                            </div>
                        </div>
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3124.8629362727847!2d-120.56858892364548!3d38.44463477329124!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x809a72fba54e8225%3A0x29c1e2fd0c43def6!2sPioneer%20Rd%2C%20Pioneer%2C%20CA%2095666!5e0!3m2!1sen!2sus!4v1759789135890!5m2!1sen!2sus"
                            width="100%" height="620" style="border:0;" allowfullscreen="" loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </section>
                <?php include("inc/footer.php"); ?>

                <script>
                document.getElementById('bookNowBtn').addEventListener('click', function() {
                    fetch('check_cart.php')
                        .then(response => response.json())
                        .then(data => {
                            if (data.hasItems) {
                                window.location.href = 'book_service.php';
                            } else {
                                window.location.href = 'book.php';
                            }
                        });
                });
                </script>
                <script>
                    $(document).on('click', '.show-detail', function () {
    const parent = $(this).closest('.services-box-sec');
    parent.find('.target').removeClass('d-none');
    parent.find('.show-detail').addClass('d-none');
    parent.find('.hide-detail').removeClass('d-none');
});

$(document).on('click', '.hide-detail', function () {
    const parent = $(this).closest('.services-box-sec');
    parent.find('.target').addClass('d-none');
    parent.find('.show-detail').removeClass('d-none');
    parent.find('.hide-detail').addClass('d-none');
});

                </script>