<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="assets/css/login_style.css" />
<title>Login | Soot Busters</title>
</head>
<body>

<div class="login-box">
    <img src="assets/images/logo.png" alt="Soot Busters Logo"> <!-- Replace with your actual logo -->
    <h2>Welcome Back</h2>

    <form action="javascript:;" method="POST" id="loginform">
        <div class="input-group">
            <label for="username">Email</label>
            <input type="email" id="lemail" name="email">
        </div>

        <div class="input-group">
            <label for="password">Password</label>
            <input type="password" id="lpassword" name="password">
        </div>

        <button type="submit">Login</button>
    </form>

   
</div>

</body>
</html>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>

<script>
$("#lemail, #lpassword").on("focus", function () {
  $(this).css("border", "1px solid #ced4da");
});
$(document).ready(function () {
  $("#loginform").submit(function (e) {
    e.preventDefault();

    var lemail = $("#lemail").val();
    var lpassword = $("#lpassword").val();
    var is_error = true;

    if (lemail == "") {
      $("#lemail").css("border", "1px solid red");
      is_error = false;
    }
    if (lpassword == "") {
      $("#lpassword").css("border", "1px solid red");
      is_error = false;
    }

    if (is_error) {
      var formData = $(this).serialize();
      $.ajax({
        url: "login_query.php",
        type: "POST",
        data: formData,
        success: function (response) {
          console.log("Server response:", response);
          if (response.trim() == "admin") {
            toastr.success("Login successful!", "Welcome Admin");
            setTimeout(function () {
              window.location.href = "admin/index.php";
            }, 1500);
          } else if (response.trim() == "invalid") {
            toastr.error("Invalid email or password!", "Error");
          } else {
            toastr.error("Unexpected error: " + response);
          }
        },
        error: function (xhr, status, error) {
          console.log(xhr.responseText);
        },
      });
    }
  });
});
</script>



