<?php
session_start();
include("inc/db_connect.php");
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

try {
    // Collect guest data
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $country_code = $_POST['country_code'];
    $phone = $_POST['phone'];
    $landline = $_POST['landline'];
    $cellphone = $_POST['cellphone'];
    $gate_code = $_POST['gate_code'];
    $address = $_POST['address'];
    $street = $_POST['street'];
    $city = $_POST['city'];
    $zip = $_POST['zip'];
    $comments = $_POST['comments'];
    $date = $_POST['date'];
    $time = $_POST['time'];

    $services = $_POST['services'] ?? [];
    $prices = $_POST['prices'] ?? [];

    if (empty($full_name) || empty($email) || empty($phone) || empty($address)) {
        echo json_encode(['success' => false, 'message' => 'Please fill all required fields.']);
        exit;
    }

    // 1️⃣ Insert into tbl_bookings
    $stmt = $conn->prepare("INSERT INTO tbl_bookings 
        (full_name, email, country_code, phone, landline, cellphone, gate_code, address, street, city, zip, comments, booking_date, booking_time, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

    $stmt->bind_param("ssssssssssssss", 
        $full_name, $email, $country_code, $phone, $landline, $cellphone,
        $gate_code, $address, $street, $city, $zip, $comments, $date, $time
    );
    $stmt->execute();
    $booking_id = $stmt->insert_id;
    $stmt->close();

    // 2️⃣ Insert each service into tbl_booking_details
    $detailStmt = $conn->prepare("INSERT INTO tbl_booking_details (booking_id, service_name, service_price) VALUES (?, ?, ?)");
    foreach ($services as $i => $name) {
        $price = $prices[$i] ?? 0;
        $detailStmt->bind_param("isd", $booking_id, $name, $price);
        $detailStmt->execute();
    }
    $detailStmt->close();

    // ✅ 3️⃣ Clear session cart after successful booking
    if (isset($_SESSION['cart'])) {
        unset($_SESSION['cart']);
    }

    if (isset($_SESSION['selected_booking'])) {
    unset($_SESSION['selected_booking']);
}

    echo json_encode(['success' => true]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}